/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.FunctionUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.LocalEvaluationContext;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.EchoFunction;
import org.junit.Assert;
import org.junit.Test;

public class FunctionUtilTest {
    @Test
    public void evaluateArithmeticFunctions() {
        Assert.assertEquals((Object)4.0, (Object)FunctionUtilTest.evaluate("+", 1.0, 3.0));
        Assert.assertEquals((Object)-2.0, (Object)FunctionUtilTest.evaluate("-", 1.0, 3.0));
        Assert.assertEquals((Object)3.0, (Object)FunctionUtilTest.evaluate("*", 1.0, 3.0));
        Assert.assertEquals((Object)0.3333333333333333, (Object)FunctionUtilTest.evaluate("/", 1.0, 3.0));
        Assert.assertEquals(null, (Object)FunctionUtilTest.evaluate("+", 1.0, null));
        Assert.assertEquals(null, (Object)FunctionUtilTest.evaluate("+", null, 1.0));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("*", 1, 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("*", Float.valueOf(1.0f), Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("*", 1.0, 1.0)));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("/", 1, 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("/", 1, Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("/", Float.valueOf(1.0f), Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("/", 1, 1.0)));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("/", Float.valueOf(1.0f), 1.0)));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("/", 1.0, 1.0)));
    }

    @Test
    public void evaluateInvalidArithmenticFunctions() {
        try {
            FunctionUtilTest.evaluate("/", 1, 0);
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        try {
            FunctionUtilTest.evaluate("/", Float.valueOf(1.0f), 0);
            FunctionUtilTest.evaluate("/", 1.0, 0);
        }
        catch (InvalidResultException ire) {
            Assert.fail();
        }
    }

    @Test
    public void evaluateAggregateFunctions() {
        List<Integer> values = Arrays.asList(1, 2, 3);
        Object min = FunctionUtilTest.evaluate("min", values);
        Assert.assertEquals((Object)1, (Object)min);
        Assert.assertEquals((Object)DataType.INTEGER, (Object)TypeUtil.getDataType((Object)min));
        Object max = FunctionUtilTest.evaluate("max", values);
        Assert.assertEquals((Object)3, (Object)max);
        Assert.assertEquals((Object)DataType.INTEGER, (Object)TypeUtil.getDataType((Object)max));
        Object average = FunctionUtilTest.evaluate("avg", values);
        Assert.assertEquals((Object)2.0, (Object)average);
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtil.getDataType((Object)average));
        Object sum = FunctionUtilTest.evaluate("sum", values);
        Assert.assertEquals((Object)6, (Object)sum);
        Assert.assertEquals((Object)DataType.INTEGER, (Object)TypeUtil.getDataType((Object)sum));
        Object product = FunctionUtilTest.evaluate("product", values);
        Assert.assertEquals((Object)6, (Object)product);
        Assert.assertEquals((Object)DataType.INTEGER, (Object)TypeUtil.getDataType((Object)product));
    }

    @Test
    public void evaluateMathFunctions() {
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("log10", 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("log10", Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("ln", 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("ln", Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("exp", 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("exp", Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("sqrt", 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("sqrt", Float.valueOf(1.0f))));
        Assert.assertEquals((Object)1, (Object)FunctionUtilTest.evaluate("abs", -1));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)FunctionUtilTest.evaluate("abs", Float.valueOf(-1.0f)));
        Assert.assertEquals((Object)1.0, (Object)FunctionUtilTest.evaluate("abs", -1.0));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("pow", 1, 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getDataType((Object)FunctionUtilTest.evaluate("pow", Float.valueOf(1.0f), Float.valueOf(1.0f))));
        Assert.assertEquals((Object)0, (Object)FunctionUtilTest.evaluate("threshold", 2, 3));
        Assert.assertEquals((Object)0, (Object)FunctionUtilTest.evaluate("threshold", 3, 3));
        Assert.assertEquals((Object)1, (Object)FunctionUtilTest.evaluate("threshold", 3, 2));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)FunctionUtilTest.evaluate("threshold", Float.valueOf(2.0f), Float.valueOf(3.0f)));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)FunctionUtilTest.evaluate("threshold", Float.valueOf(3.0f), Float.valueOf(3.0f)));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)FunctionUtilTest.evaluate("threshold", Float.valueOf(3.0f), Float.valueOf(2.0f)));
        Assert.assertEquals((Object)1, (Object)FunctionUtilTest.evaluate("floor", 1));
        Assert.assertEquals((Object)1, (Object)FunctionUtilTest.evaluate("ceil", 1));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)FunctionUtilTest.evaluate("floor", Float.valueOf(1.99f)));
        Assert.assertEquals((Object)Float.valueOf(2.0f), (Object)FunctionUtilTest.evaluate("round", Float.valueOf(1.99f)));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)FunctionUtilTest.evaluate("ceil", Float.valueOf(0.01f)));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)FunctionUtilTest.evaluate("round", Float.valueOf(0.01f)));
    }

    @Test
    public void evaluateValueFunctions() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isMissing", new Object[]{null}));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("isMissing", "value"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isNotMissing", "value"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("isNotMissing", new Object[]{null}));
    }

    @Test
    public void evaluateEqualityFunctions() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("equal", 1, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("equal", 1.0, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("notEqual", 1.0, 3.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("notEqual", 1, 3));
    }

    @Test
    public void evaluateComparisonFunctions() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("lessThan", 1.0, 3.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("lessThan", 1, 3.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("lessOrEqual", 1.0, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("lessOrEqual", 1, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("greaterThan", 3.0, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("greaterThan", 3, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("greaterOrEqual", 3.0, 3.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("greaterOrEqual", 3, 3.0));
    }

    @Test
    public void evaluateBooleanComparisonFunctions() {
        try {
            FunctionUtilTest.evaluate("lessOrEqual", false, "false");
            Assert.fail();
        }
        catch (TypeCheckException tce) {
            // empty catch block
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("lessThan", false, 0.5));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("lessThan", true, 0.5));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("lessOrEqual", false, 0.0));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("lessOrEqual", true, 0.0));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("greaterThan", false, 0.5));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("greaterThan", true, 0.5));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("greaterOrEqual", false, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("greaterOrEqual", true, 1.0));
        try {
            FunctionUtilTest.evaluate("lessOrEqual", false, false);
            Assert.fail();
        }
        catch (TypeCheckException typeCheckException) {
            // empty catch block
        }
    }

    @Test
    public void evaluateBinaryFunctions() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("and", Boolean.TRUE, Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("and", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("and", Boolean.TRUE, Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("and", Boolean.FALSE, Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("or", Boolean.FALSE, Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("or", Boolean.FALSE, Boolean.FALSE, Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("or", Boolean.FALSE, Boolean.FALSE));
    }

    @Test
    public void evaluateUnaryFunction() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("not", Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("not", Boolean.TRUE));
    }

    @Test
    public void evaluateValueListFunctions() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isIn", "3", "1", "2", "3"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isNotIn", "0", "1", "2", "3"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isIn", 3, 1, 2, 3));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isNotIn", 0, 1, 2, 3));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isIn", 3.0, 1.0, 2.0, 3.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isNotIn", 0.0, 1.0, 2.0, 3.0));
    }

    @Test
    public void evaluateIfFunction() {
        Assert.assertEquals((Object)"left", (Object)FunctionUtilTest.evaluate("if", Boolean.TRUE, "left"));
        Assert.assertEquals((Object)"left", (Object)FunctionUtilTest.evaluate("if", Boolean.TRUE, "left", "right"));
        Assert.assertEquals(null, (Object)FunctionUtilTest.evaluate("if", Boolean.FALSE, "left"));
        Assert.assertEquals((Object)"right", (Object)FunctionUtilTest.evaluate("if", Boolean.FALSE, "left", "right"));
    }

    @Test
    public void evaluateStringFunctions() {
        Assert.assertEquals((Object)"VALUE", (Object)FunctionUtilTest.evaluate("uppercase", "Value"));
        Assert.assertEquals((Object)"value", (Object)FunctionUtilTest.evaluate("lowercase", "Value"));
        Assert.assertEquals((Object)"", (Object)FunctionUtilTest.evaluate("substring", "value", 1, 0));
        Assert.assertEquals((Object)"value", (Object)FunctionUtilTest.evaluate("substring", "value", 1, 5));
        Assert.assertEquals((Object)"alue", (Object)FunctionUtilTest.evaluate("substring", "value", 2, 4));
        Assert.assertEquals((Object)"valu", (Object)FunctionUtilTest.evaluate("substring", "value", 1, 4));
        Assert.assertEquals((Object)"value", (Object)FunctionUtilTest.evaluate("trimBlanks", "\tvalue\t"));
    }

    @Test
    public void evaluateConcatenationFunction() {
        Assert.assertEquals((Object)"2-2000", (Object)FunctionUtilTest.evaluate("concat", "2", "-", "2000"));
        Assert.assertEquals((Object)"2-2000", (Object)FunctionUtilTest.evaluate("concat", "2", null, "-", null, "2000"));
        Assert.assertEquals((Object)"2-2000", (Object)FunctionUtilTest.evaluate("concat", 2, "-", 2000));
    }

    @Test
    public void evaluateRegularExpressionFunctions() {
        Assert.assertEquals((Object)"c", (Object)FunctionUtilTest.evaluate("replace", "BBBB", "B+", "c"));
        Assert.assertEquals((Object)"cccc", (Object)FunctionUtilTest.evaluate("replace", "BBBB", "B+?", "c"));
        Assert.assertEquals((Object)"a*cada*", (Object)FunctionUtilTest.evaluate("replace", "abracadabra", "bra", "*"));
        Assert.assertEquals((Object)"*", (Object)FunctionUtilTest.evaluate("replace", "abracadabra", "a.*a", "*"));
        Assert.assertEquals((Object)"*c*bra", (Object)FunctionUtilTest.evaluate("replace", "abracadabra", "a.*?a", "*"));
        Assert.assertEquals((Object)"brcdbr", (Object)FunctionUtilTest.evaluate("replace", "abracadabra", "a", ""));
        Assert.assertEquals((Object)"abbraccaddabbra", (Object)FunctionUtilTest.evaluate("replace", "abracadabra", "a(.)", "a$1$1"));
        String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        for (int i = 0; i < monthNames.length; ++i) {
            Boolean matches = i == 0 || i == 1 || i == 4;
            Assert.assertEquals((Object)matches, (Object)FunctionUtilTest.evaluate("matches", monthNames[i], "ar?y"));
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("matches", "abracadabra", "bra"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("matches", "abracadabra", "^a.*a$"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("matches", "abracadabra", "^bra"));
    }

    @Test
    public void evaluateFormatFunctions() {
        Assert.assertEquals((Object)"  2", (Object)FunctionUtilTest.evaluate("formatNumber", 2, "%3d"));
        Assert.assertEquals((Object)"08/20/04", (Object)FunctionUtilTest.evaluate("formatDatetime", new LocalDate(2004, 8, 20), "%m/%d/%y"));
    }

    @Test
    public void evaluateDateTimeFunctions() {
        Assert.assertEquals((Object)15796, (Object)FunctionUtilTest.evaluate("dateDaysSinceYear", new LocalDate(2003, 4, 1), 1960));
        Assert.assertEquals((Object)15796, (Object)FunctionUtilTest.evaluate("dateDaysSinceYear", new LocalDateTime(2003, 4, 1, 0, 0, 0), 1960));
        Assert.assertEquals((Object)19410, (Object)FunctionUtilTest.evaluate("dateSecondsSinceMidnight", new LocalTime(5, 23, 30)));
        Assert.assertEquals((Object)19410, (Object)FunctionUtilTest.evaluate("dateSecondsSinceMidnight", new LocalDateTime(1960, 1, 1, 5, 23, 30)));
        Assert.assertEquals((Object)185403, (Object)FunctionUtilTest.evaluate("dateSecondsSinceYear", new LocalDateTime(1960, 1, 3, 3, 30, 3), 1960));
    }

    @Test
    public void evaluateEchoFunction() {
        String function = EchoFunction.class.getName();
        try {
            FunctionUtilTest.evaluate(function, new Object[0]);
            Assert.fail();
        }
        catch (FunctionException fe) {
            // empty catch block
        }
        Assert.assertEquals((Object)"Hello World!", (Object)FunctionUtilTest.evaluate(function, "Hello World!"));
        try {
            FunctionUtilTest.evaluate(function, "Hello World!", "Hello World!");
            Assert.fail();
        }
        catch (FunctionException functionException) {
            // empty catch block
        }
    }

    private static Object evaluate(String function, Object ... values) {
        return FunctionUtilTest.evaluate(function, Arrays.asList(values));
    }

    private static Object evaluate(String function, List<?> values) {
        Apply apply = new Apply(function);
        LocalEvaluationContext context = new LocalEvaluationContext();
        Function<Object, FieldValue> transformer = new Function<Object, FieldValue>(){

            public FieldValue apply(Object object) {
                return FieldValueUtil.create((Object)object);
            }
        };
        FieldValue result = FunctionUtil.evaluate((Apply)apply, (List)Lists.newArrayList((Iterable)Iterables.transform(values, (Function)transformer)), (EvaluationContext)context);
        return FieldValueUtil.getValue((FieldValue)result);
    }
}

