/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.FieldName;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.jpmml.evaluator.NormalizationUtil;
import org.junit.Assert;
import org.junit.Test;

public class NormalizationUtilTest {
    private static final double[] BEGIN = new double[]{0.01, 0.0};
    private static final double[] MIDPOINT = new double[]{3.07897, 0.5};
    private static final double[] END = new double[]{11.44, 1.0};

    @Test
    public void normalize() {
        NormContinuous normContinuous = NormalizationUtilTest.createNormContinuous();
        Assert.assertEquals((double)BEGIN[1], (double)NormalizationUtil.normalize((NormContinuous)normContinuous, (double)BEGIN[0]), (double)1.0E-8);
        Assert.assertEquals((double)NormalizationUtilTest.interpolate(1.212, BEGIN, MIDPOINT), (double)NormalizationUtil.normalize((NormContinuous)normContinuous, (double)1.212), (double)1.0E-8);
        Assert.assertEquals((double)MIDPOINT[1], (double)NormalizationUtil.normalize((NormContinuous)normContinuous, (double)MIDPOINT[0]), (double)1.0E-8);
        Assert.assertEquals((double)NormalizationUtilTest.interpolate(6.5, MIDPOINT, END), (double)NormalizationUtil.normalize((NormContinuous)normContinuous, (double)6.5), (double)1.0E-8);
        Assert.assertEquals((double)END[1], (double)NormalizationUtil.normalize((NormContinuous)normContinuous, (double)END[0]), (double)1.0E-8);
    }

    @Test
    public void normalizeOutliers() {
        NormContinuous normContinuous = NormalizationUtilTest.createNormContinuous();
        Assert.assertEquals((double)NormalizationUtilTest.interpolate(-1.0, BEGIN, MIDPOINT), (double)NormalizationUtil.normalize((NormContinuous)normContinuous, (double)-1.0), (double)1.0E-8);
        Assert.assertEquals((double)NormalizationUtilTest.interpolate(12.2, MIDPOINT, END), (double)NormalizationUtil.normalize((NormContinuous)normContinuous, (double)12.2), (double)1.0E-8);
        normContinuous = normContinuous.withOutliers(OutlierTreatmentMethodType.AS_MISSING_VALUES).withMapMissingTo(Double.valueOf(0.5));
        Assert.assertEquals((double)0.5, (double)NormalizationUtil.normalize((NormContinuous)normContinuous, (double)-1.0), (double)1.0E-8);
        Assert.assertEquals((double)0.5, (double)NormalizationUtil.normalize((NormContinuous)normContinuous, (double)12.2), (double)1.0E-8);
        normContinuous = normContinuous.withOutliers(OutlierTreatmentMethodType.AS_EXTREME_VALUES);
        Assert.assertEquals((double)BEGIN[1], (double)NormalizationUtil.normalize((NormContinuous)normContinuous, (double)-1.0), (double)1.0E-8);
        Assert.assertEquals((double)END[1], (double)NormalizationUtil.normalize((NormContinuous)normContinuous, (double)12.2), (double)1.0E-8);
    }

    @Test
    public void denormalize() {
        NormContinuous normContinuous = NormalizationUtilTest.createNormContinuous();
        Assert.assertEquals((double)BEGIN[0], (double)NormalizationUtil.denormalize((NormContinuous)normContinuous, (double)BEGIN[1]), (double)1.0E-8);
        Assert.assertEquals((double)0.3, (double)NormalizationUtil.denormalize((NormContinuous)normContinuous, (double)NormalizationUtilTest.interpolate(0.3, BEGIN, MIDPOINT)), (double)1.0E-8);
        Assert.assertEquals((double)MIDPOINT[0], (double)NormalizationUtil.denormalize((NormContinuous)normContinuous, (double)MIDPOINT[1]), (double)1.0E-8);
        Assert.assertEquals((double)7.123, (double)NormalizationUtil.denormalize((NormContinuous)normContinuous, (double)NormalizationUtilTest.interpolate(7.123, MIDPOINT, END)), (double)1.0E-8);
        Assert.assertEquals((double)END[0], (double)NormalizationUtil.denormalize((NormContinuous)normContinuous, (double)END[1]), (double)1.0E-8);
    }

    private static double interpolate(double x, double[] begin, double[] end) {
        return begin[1] + (x - begin[0]) / (end[0] - begin[0]) * (end[1] - begin[1]);
    }

    private static NormContinuous createNormContinuous() {
        NormContinuous result = new NormContinuous(new FieldName("x")).withLinearNorms(new LinearNorm[]{new LinearNorm(BEGIN[0], BEGIN[1]), new LinearNorm(MIDPOINT[0], MIDPOINT[1]), new LinearNorm(END[0], END[1])});
        return result;
    }
}

