/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;

public class CategoricalValue
extends FieldValue {
    private static final Double ONE = 1.0;
    private static final Double ZERO = 0.0;

    public CategoricalValue(DataType dataType, Object value) {
        super(dataType, value);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public int compareToString(String string) {
        DataType dataType = this.getDataType();
        if (DataType.BOOLEAN.equals((Object)dataType)) {
            Boolean value = this.asBoolean();
            try {
                return TypeUtil.compare(DataType.DOUBLE, CategoricalValue.toDouble(value), TypeUtil.parse(DataType.DOUBLE, string));
            }
            catch (NumberFormatException nfe) {
                throw new TypeCheckException(DataType.DOUBLE, (Object)string);
            }
        }
        throw new EvaluationException();
    }

    @Override
    public int compareToValue(FieldValue that) {
        DataType dataType = this.getDataType();
        if (DataType.BOOLEAN.equals((Object)dataType)) {
            Boolean value = this.asBoolean();
            try {
                return TypeUtil.compare(DataType.DOUBLE, CategoricalValue.toDouble(value), that.asNumber());
            }
            catch (TypeCheckException tce) {
                throw new TypeCheckException(DataType.DOUBLE, that.getValue());
            }
        }
        throw new EvaluationException();
    }

    private static Double toDouble(Boolean value) {
        return value != false ? ONE : ZERO;
    }
}

