/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Product;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.dmg.pmml.DataType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Seconds;
import org.jpmml.evaluator.DaysSinceDate;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.SecondsSinceDate;
import org.jpmml.evaluator.SecondsSinceMidnight;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;
import org.jpmml.evaluator.functions.AggregateFunction;
import org.jpmml.evaluator.functions.ArithmeticFunction;
import org.jpmml.evaluator.functions.BinaryBooleanFunction;
import org.jpmml.evaluator.functions.ComparisonFunction;
import org.jpmml.evaluator.functions.EqualityFunction;
import org.jpmml.evaluator.functions.FpMathFunction;
import org.jpmml.evaluator.functions.MathFunction;
import org.jpmml.evaluator.functions.StringFunction;
import org.jpmml.evaluator.functions.UnaryBooleanFunction;
import org.jpmml.evaluator.functions.ValueFunction;
import org.jpmml.evaluator.functions.ValueListFunction;

public class FunctionRegistry {
    private static final Map<String, Function> functions = Maps.newLinkedHashMap();

    private FunctionRegistry() {
    }

    public static Function getFunction(String name) {
        Function function = functions.get(name);
        if (function == null) {
            function = FunctionRegistry.loadJavaFunction(name);
        }
        return function;
    }

    public static void putFunction(Function function) {
        FunctionRegistry.putFunction(function.getName(), function);
    }

    public static void putFunction(String name, Function function) {
        functions.put(name, function);
    }

    private static Function loadJavaFunction(String name) {
        Function function;
        Class<?> clazz;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = FunctionRegistry.class.getClassLoader();
            }
            clazz = classLoader.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        if (!Function.class.isAssignableFrom(clazz)) {
            return null;
        }
        try {
            function = (Function)clazz.newInstance();
        }
        catch (Exception e) {
            throw new EvaluationException();
        }
        return function;
    }

    static {
        FunctionRegistry.putFunction(new ArithmeticFunction("+"){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() + right.doubleValue();
            }
        });
        FunctionRegistry.putFunction(new ArithmeticFunction("-"){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() - right.doubleValue();
            }
        });
        FunctionRegistry.putFunction(new ArithmeticFunction("*"){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() * right.doubleValue();
            }
        });
        FunctionRegistry.putFunction(new ArithmeticFunction("/"){

            @Override
            public Number evaluate(Number left, Number right) {
                if (left instanceof Integer && right instanceof Integer) {
                    return left.intValue() / right.intValue();
                }
                return left.doubleValue() / right.doubleValue();
            }
        });
        FunctionRegistry.putFunction(new AggregateFunction("min"){

            public Min createStatistic() {
                return new Min();
            }
        });
        FunctionRegistry.putFunction(new AggregateFunction("max"){

            public Max createStatistic() {
                return new Max();
            }
        });
        FunctionRegistry.putFunction(new AggregateFunction("avg"){

            public Mean createStatistic() {
                return new Mean();
            }

            @Override
            public DataType getResultType(DataType dataType) {
                return 7.integerToDouble(dataType);
            }
        });
        FunctionRegistry.putFunction(new AggregateFunction("sum"){

            public Sum createStatistic() {
                return new Sum();
            }
        });
        FunctionRegistry.putFunction(new AggregateFunction("product"){

            public Product createStatistic() {
                return new Product();
            }
        });
        FunctionRegistry.putFunction(new FpMathFunction("log10"){

            @Override
            public Double evaluate(Number value) {
                return Math.log10(value.doubleValue());
            }
        });
        FunctionRegistry.putFunction(new FpMathFunction("ln"){

            @Override
            public Double evaluate(Number value) {
                return Math.log(value.doubleValue());
            }
        });
        FunctionRegistry.putFunction(new FpMathFunction("exp"){

            @Override
            public Double evaluate(Number value) {
                return Math.exp(value.doubleValue());
            }
        });
        FunctionRegistry.putFunction(new FpMathFunction("sqrt"){

            @Override
            public Double evaluate(Number value) {
                return Math.sqrt(value.doubleValue());
            }
        });
        FunctionRegistry.putFunction(new MathFunction("abs"){

            @Override
            public Double evaluate(Number value) {
                return Math.abs(value.doubleValue());
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("pow"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                this.checkArguments(arguments, 2);
                FieldValue left = arguments.get(0);
                FieldValue right = arguments.get(1);
                DataType dataType = TypeUtil.getResultDataType(left.getDataType(), right.getDataType());
                Double result = Math.pow(left.asNumber().doubleValue(), right.asNumber().doubleValue());
                return FieldValueUtil.create(15.cast(dataType, result));
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("threshold"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                this.checkArguments(arguments, 2);
                FieldValue left = arguments.get(0);
                FieldValue right = arguments.get(1);
                DataType dataType = TypeUtil.getResultDataType(left.getDataType(), right.getDataType());
                Integer result = left.asNumber().doubleValue() > right.asNumber().doubleValue() ? 1 : 0;
                return FieldValueUtil.create(16.cast(dataType, result));
            }
        });
        FunctionRegistry.putFunction(new MathFunction("floor"){

            @Override
            public Double evaluate(Number number) {
                return Math.floor(number.doubleValue());
            }
        });
        FunctionRegistry.putFunction(new MathFunction("ceil"){

            @Override
            public Double evaluate(Number number) {
                return Math.ceil(number.doubleValue());
            }
        });
        FunctionRegistry.putFunction(new MathFunction("round"){

            @Override
            public Double evaluate(Number number) {
                return Math.round(number.doubleValue());
            }
        });
        FunctionRegistry.putFunction(new ValueFunction("isMissing"){

            @Override
            public Boolean evaluate(FieldValue value) {
                return value == null;
            }
        });
        FunctionRegistry.putFunction(new ValueFunction("isNotMissing"){

            @Override
            public Boolean evaluate(FieldValue value) {
                return value != null;
            }
        });
        FunctionRegistry.putFunction(new EqualityFunction("equal"){

            @Override
            public Boolean evaluate(boolean equals) {
                return equals;
            }
        });
        FunctionRegistry.putFunction(new EqualityFunction("notEqual"){

            @Override
            public Boolean evaluate(boolean equals) {
                return !equals;
            }
        });
        FunctionRegistry.putFunction(new ComparisonFunction("lessThan"){

            @Override
            public Boolean evaluate(int order) {
                return order < 0;
            }
        });
        FunctionRegistry.putFunction(new ComparisonFunction("lessOrEqual"){

            @Override
            public Boolean evaluate(int order) {
                return order <= 0;
            }
        });
        FunctionRegistry.putFunction(new ComparisonFunction("greaterThan"){

            @Override
            public Boolean evaluate(int order) {
                return order > 0;
            }
        });
        FunctionRegistry.putFunction(new ComparisonFunction("greaterOrEqual"){

            @Override
            public Boolean evaluate(int order) {
                return order >= 0;
            }
        });
        FunctionRegistry.putFunction(new BinaryBooleanFunction("and"){

            @Override
            public Boolean evaluate(Boolean left, Boolean right) {
                return left & right;
            }
        });
        FunctionRegistry.putFunction(new BinaryBooleanFunction("or"){

            @Override
            public Boolean evaluate(Boolean left, Boolean right) {
                return left | right;
            }
        });
        FunctionRegistry.putFunction(new UnaryBooleanFunction("not"){

            @Override
            public Boolean evaluate(Boolean value) {
                return value == false;
            }
        });
        FunctionRegistry.putFunction(new ValueListFunction("isIn"){

            @Override
            public Boolean evaluate(FieldValue value, List<FieldValue> values) {
                return value.equalsAnyValue(values);
            }
        });
        FunctionRegistry.putFunction(new ValueListFunction("isNotIn"){

            @Override
            public Boolean evaluate(FieldValue value, List<FieldValue> values) {
                return !value.equalsAnyValue(values);
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("if"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                FieldValue falseValue;
                if (arguments.size() < 2 || arguments.size() > 3) {
                    throw new FunctionException(this.getName(), "Expected 2 or 3 arguments, but got " + arguments.size() + " arguments");
                }
                FieldValue flag = arguments.get(0);
                if (flag == null) {
                    throw new FunctionException(this.getName(), "Missing arguments");
                }
                if (flag.asBoolean().booleanValue()) {
                    FieldValue trueValue = arguments.get(1);
                    if (trueValue == null) {
                        throw new FunctionException(this.getName(), "Missing arguments");
                    }
                    return trueValue;
                }
                FieldValue fieldValue = falseValue = arguments.size() > 2 ? arguments.get(2) : null;
                if (falseValue == null) {
                    return null;
                }
                return falseValue;
            }
        });
        FunctionRegistry.putFunction(new StringFunction("uppercase"){

            @Override
            public String evaluate(String value) {
                return value.toUpperCase();
            }
        });
        FunctionRegistry.putFunction(new StringFunction("lowercase"){

            @Override
            public String evaluate(String value) {
                return value.toLowerCase();
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("substring"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                this.checkArguments(arguments, 3);
                String string = arguments.get(0).asString();
                int position = arguments.get(1).asInteger();
                int length = arguments.get(2).asInteger();
                if (position <= 0 || length < 0) {
                    throw new FunctionException(this.getName(), "Invalid arguments");
                }
                String result = string.substring(position - 1, position + length - 1);
                return FieldValueUtil.create(result);
            }
        });
        FunctionRegistry.putFunction(new StringFunction("trimBlanks"){

            @Override
            public String evaluate(String value) {
                return value.trim();
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("concat"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                this.checkVariableArguments(arguments, 2, true);
                StringBuilder sb = new StringBuilder();
                Iterable values = Iterables.filter(arguments, (Predicate)Predicates.notNull());
                for (FieldValue value : values) {
                    String string = (String)TypeUtil.cast(DataType.STRING, value.getValue());
                    sb.append(string);
                }
                return FieldValueUtil.create(sb.toString());
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("replace"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                this.checkArguments(arguments, 3);
                String input = arguments.get(0).asString();
                String pattern = arguments.get(1).asString();
                String replacement = arguments.get(2).asString();
                Matcher matcher = Pattern.compile(pattern).matcher(input);
                String result = matcher.replaceAll(replacement);
                return FieldValueUtil.create(result);
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("matches"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                this.checkArguments(arguments, 2);
                String input = arguments.get(0).asString();
                String pattern = arguments.get(1).asString();
                Matcher matcher = Pattern.compile(pattern).matcher(input);
                Boolean result = matcher.find();
                return FieldValueUtil.create(result);
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("formatNumber"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                this.checkArguments(arguments, 2);
                FieldValue value = arguments.get(0);
                FieldValue pattern = arguments.get(1);
                String result = String.format(pattern.asString(), value.asNumber());
                return FieldValueUtil.create(result);
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("formatDatetime"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                this.checkArguments(arguments, 2);
                FieldValue value = arguments.get(0);
                FieldValue pattern = arguments.get(1);
                String result = String.format(this.translatePattern(pattern.asString()), value.asDateTime().toDate());
                return FieldValueUtil.create(result);
            }

            private String translatePattern(String pattern) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < pattern.length(); ++i) {
                    char c = pattern.charAt(i);
                    sb.append(c);
                    if (c != '%' || i >= pattern.length() - 1 || pattern.charAt(i + 1) == '%') continue;
                    sb.append("1$t");
                }
                return sb.toString();
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("dateDaysSinceYear"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                this.checkArguments(arguments, 2);
                LocalDate instant = arguments.get(0).asLocalDate();
                int year = arguments.get(1).asInteger();
                DaysSinceDate period = new DaysSinceDate(year, instant);
                return FieldValueUtil.create(period.intValue());
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("dateSecondsSinceMidnight"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                this.checkArguments(arguments, 1);
                LocalTime instant = arguments.get(0).asLocalTime();
                Seconds seconds = Seconds.seconds((int)(instant.getHourOfDay() * 60 * 60 + instant.getMinuteOfHour() * 60 + instant.getSecondOfMinute()));
                SecondsSinceMidnight period = new SecondsSinceMidnight(seconds);
                return FieldValueUtil.create(period.intValue());
            }
        });
        FunctionRegistry.putFunction(new AbstractFunction("dateSecondsSinceYear"){

            @Override
            public FieldValue evaluate(List<FieldValue> arguments) {
                this.checkArguments(arguments, 2);
                LocalDateTime instant = arguments.get(0).asLocalDateTime();
                int year = arguments.get(1).asInteger();
                SecondsSinceDate period = new SecondsSinceDate(year, instant);
                return FieldValueUtil.create(period.intValue());
            }
        });
    }
}

