/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Map;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.ModelEvaluator;

public class ModelEvaluationContext
extends EvaluationContext {
    private ModelEvaluationContext parent = null;
    private ModelEvaluator<?> modelEvaluator = null;

    public ModelEvaluationContext(ModelEvaluationContext parent, ModelEvaluator<?> modelEvaluator) {
        this.setParent(parent);
        this.setModelEvaluator(modelEvaluator);
    }

    @Override
    public Map.Entry<FieldName, FieldValue> getFieldEntry(FieldName name) {
        Map.Entry<FieldName, FieldValue> entry = super.getFieldEntry(name);
        if (entry == null) {
            ModelEvaluationContext parent = this.getParent();
            if (parent != null) {
                return parent.getFieldEntry(name);
            }
            return null;
        }
        return entry;
    }

    @Override
    public EvaluationContext.Result<DerivedField> resolveDerivedField(FieldName name) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        DerivedField derivedField = modelEvaluator.getLocalDerivedField(name);
        if (derivedField == null) {
            ModelEvaluationContext parent = this.getParent();
            if (parent != null) {
                return parent.resolveDerivedField(name);
            }
            derivedField = modelEvaluator.getDerivedField(name);
        }
        return this.createResult(derivedField);
    }

    @Override
    public EvaluationContext.Result<DefineFunction> resolveFunction(String name) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        DefineFunction defineFunction = modelEvaluator.getFunction(name);
        return this.createResult(defineFunction);
    }

    @Override
    public FieldValue createFieldValue(FieldName name, Object value) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        MiningField miningField = modelEvaluator.getMiningField(name);
        if (miningField != null) {
            return EvaluatorUtil.prepare(modelEvaluator, name, value);
        }
        return super.createFieldValue(name, value);
    }

    public ModelEvaluationContext getParent() {
        return this.parent;
    }

    private void setParent(ModelEvaluationContext parent) {
        this.parent = parent;
    }

    public ModelEvaluator<?> getModelEvaluator() {
        return this.modelEvaluator;
    }

    private void setModelEvaluator(ModelEvaluator<?> modelEvaluator) {
        this.modelEvaluator = modelEvaluator;
    }
}

