/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.Seconds;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.PreciseDurationDateTimeField;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.jpmml.evaluator.SimplePeriod;

public class SecondsSinceMidnight
extends SimplePeriod<SecondsSinceMidnight> {
    private Seconds seconds = null;
    private static DateTimeFormatter format = null;

    public SecondsSinceMidnight(Seconds seconds) {
        this.setSeconds(seconds);
    }

    @Override
    public int intValue() {
        return this.getSeconds().getSeconds();
    }

    @Override
    public int compareTo(SecondsSinceMidnight that) {
        return this.getSeconds().compareTo((BaseSingleFieldPeriod)that.getSeconds());
    }

    public int hashCode() {
        return this.getSeconds().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof SecondsSinceMidnight) {
            SecondsSinceMidnight that = (SecondsSinceMidnight)object;
            return this.getSeconds().equals((Object)that.getSeconds());
        }
        return false;
    }

    public Seconds getSeconds() {
        return this.seconds;
    }

    private void setSeconds(Seconds seconds) {
        this.seconds = seconds;
    }

    public static DateTimeFormatter getFormat() {
        if (format == null) {
            format = SecondsSinceMidnight.createFormat();
        }
        return format;
    }

    private static DateTimeFormatter createFormat() {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendSignedDecimal((DateTimeFieldType)HoursOfEpochFieldType.getInstance(), 1, 4).appendLiteral(':').appendFixedDecimal(DateTimeFieldType.minuteOfHour(), 2).appendLiteral(':').appendFixedDecimal(DateTimeFieldType.secondOfMinute(), 2);
        return builder.toFormatter();
    }

    private static class HoursOfEpochFieldType
    extends DateTimeFieldType {
        private static HoursOfEpochFieldType instance;
        private static final long millisInHour = 3600000L;

        private HoursOfEpochFieldType() {
            super("hoursOfEpoch");
        }

        public DurationFieldType getDurationType() {
            return DurationFieldType.hours();
        }

        public DurationFieldType getRangeDurationType() {
            return null;
        }

        public DateTimeField getField(Chronology chronology) {
            chronology = DateTimeUtils.getChronology((Chronology)chronology);
            return new PreciseDurationDateTimeField(this, chronology.hours()){

                public int get(long millis) {
                    long hours = millis / 3600000L;
                    return FieldUtils.safeToInt((long)hours);
                }

                public DurationField getRangeDurationField() {
                    return null;
                }

                public int getMinimumValue() {
                    return 0;
                }

                public int getMaximumValue() {
                    return Integer.MAX_VALUE;
                }
            };
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof HoursOfEpochFieldType) {
                HoursOfEpochFieldType that = (HoursOfEpochFieldType)((Object)object);
                return this.getName().equals(that.getName());
            }
            return false;
        }

        public static HoursOfEpochFieldType getInstance() {
            if (instance == null) {
                instance = new HoursOfEpochFieldType();
            }
            return instance;
        }
    }
}

