/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dmg.pmml.IntSparseArray;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.SparseArray;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class SparseArrayUtil {
    private static final LoadingCache<SparseArray<?>, SortedMap<Integer, ? extends Number>> contentCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<SparseArray<?>, SortedMap<Integer, ? extends Number>>(){

        public SortedMap<Integer, ? extends Number> load(SparseArray<?> sparseArray) {
            return ImmutableSortedMap.copyOf(SparseArrayUtil.parse(sparseArray));
        }
    });

    private SparseArrayUtil() {
    }

    public static <E extends Number> int getSize(SparseArray<E> sparseArray) {
        Integer n = sparseArray.getN();
        if (n != null) {
            return n;
        }
        SortedMap<Integer, E> content = SparseArrayUtil.getContent(sparseArray);
        return content.size();
    }

    public static <E extends Number> SortedMap<Integer, E> getContent(SparseArray<E> sparseArray) {
        return CacheUtil.getValue(sparseArray, contentCache);
    }

    public static <E extends Number> double[] toArray(SparseArray<E> sparseArray) {
        int size = SparseArrayUtil.getSize(sparseArray);
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            E value = SparseArrayUtil.getValue(sparseArray, i + 1);
            result[i] = ((Number)value).doubleValue();
        }
        return result;
    }

    public static <E extends Number> SortedMap<Integer, E> parse(SparseArray<E> sparseArray) {
        TreeMap result = Maps.newTreeMap();
        List indices = sparseArray.getIndices();
        List entries = sparseArray.getEntries();
        if (indices.size() != entries.size()) {
            throw new InvalidFeatureException(sparseArray);
        }
        for (int i = 0; i < indices.size(); ++i) {
            Integer index = (Integer)indices.get(i);
            Number entry = (Number)entries.get(i);
            SparseArrayUtil.checkIndex(sparseArray, index);
            result.put(index, entry);
        }
        Integer n = sparseArray.getN();
        if (n != null && n < result.size()) {
            throw new InvalidFeatureException(sparseArray);
        }
        return result;
    }

    public static <E extends Number> E getValue(SparseArray<E> sparseArray, Integer index) {
        if (sparseArray instanceof IntSparseArray) {
            return (E)SparseArrayUtil.getIntValue((IntSparseArray)sparseArray, index);
        }
        if (sparseArray instanceof RealSparseArray) {
            return (E)SparseArrayUtil.getRealValue((RealSparseArray)sparseArray, index);
        }
        throw new UnsupportedFeatureException(sparseArray);
    }

    public static Integer getIntValue(IntSparseArray sparseArray, Integer index) {
        SortedMap content = SparseArrayUtil.getContent(sparseArray);
        Integer result = (Integer)content.get(index);
        if (result == null) {
            SparseArrayUtil.checkIndex(sparseArray, index);
            return sparseArray.getDefaultValue();
        }
        return result;
    }

    public static Double getRealValue(RealSparseArray sparseArray, Integer index) {
        SortedMap content = SparseArrayUtil.getContent(sparseArray);
        Double result = (Double)content.get(index);
        if (result == null) {
            SparseArrayUtil.checkIndex(sparseArray, index);
            return sparseArray.getDefaultValue();
        }
        return result;
    }

    private static <E extends Number> void checkIndex(SparseArray<E> sparseArray, Integer index) {
        Integer n = sparseArray.getN();
        if (index < 1 || n != null && index > n) {
            throw new EvaluationException();
        }
    }
}

