/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.ActivationFunctionType;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.BaselineModel;
import org.dmg.pmml.Categories;
import org.dmg.pmml.CenterFields;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.ContinuousScoringMethodType;
import org.dmg.pmml.DecisionTree;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.GeneralRegressionModel;
import org.dmg.pmml.LinkFunctionType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.MissingValueStrategyType;
import org.dmg.pmml.MultipleModelMethodType;
import org.dmg.pmml.NearestNeighborModel;
import org.dmg.pmml.NeuralLayer;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predictor;
import org.dmg.pmml.Regression;
import org.dmg.pmml.ResultFeatureType;
import org.dmg.pmml.Segmentation;
import org.dmg.pmml.SequenceModel;
import org.dmg.pmml.SupportVectorMachineModel;
import org.dmg.pmml.SvmRepresentationType;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.TargetValueStat;
import org.dmg.pmml.TextModel;
import org.dmg.pmml.TimeSeriesModel;
import org.dmg.pmml.TreeModel;
import org.dmg.pmml.VisitorAction;
import org.jpmml.manager.UnsupportedFeatureException;
import org.jpmml.model.AbstractSimpleVisitor;

public class UnsupportedFeatureInspector
extends AbstractSimpleVisitor {
    private List<UnsupportedFeatureException> exceptions = Lists.newArrayList();

    public VisitorAction visit(Aggregate aggregate) {
        Aggregate.Function function = aggregate.getFunction();
        switch (function) {
            case MULTISET: {
                this.report(new UnsupportedFeatureException((PMMLObject)aggregate, (Enum)function));
                break;
            }
        }
        return super.visit(aggregate);
    }

    public VisitorAction visit(BaselineModel baselineModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)baselineModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(CenterFields centerFields) {
        this.report(new UnsupportedFeatureException((PMMLObject)centerFields));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(ClusteringModel clusteringModel) {
        ClusteringModel.ModelClass modelClass = clusteringModel.getModelClass();
        switch (modelClass) {
            case DISTRIBUTION_BASED: {
                this.report(new UnsupportedFeatureException((PMMLObject)clusteringModel, (Enum)modelClass));
                break;
            }
        }
        return super.visit(clusteringModel);
    }

    public VisitorAction visit(DecisionTree decisionTree) {
        this.report(new UnsupportedFeatureException((PMMLObject)decisionTree));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(GeneralRegressionModel generalRegressionModel) {
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case COX_REGRESSION: {
                this.report(new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)modelType));
                return VisitorAction.SKIP;
            }
        }
        LinkFunctionType linkFunction = generalRegressionModel.getLinkFunction();
        switch (linkFunction) {
            case CAUCHIT: 
            case NEGBIN: {
                this.report(new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)linkFunction));
                break;
            }
        }
        return super.visit(generalRegressionModel);
    }

    public VisitorAction visit(MiningModel miningModel) {
        MiningFunctionType miningFunction = miningModel.getFunctionName();
        block0 : switch (miningFunction) {
            case REGRESSION: 
            case CLASSIFICATION: {
                Segmentation segmentation = miningModel.getSegmentation();
                MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
                switch (multipleModelMethod) {
                    case MEDIAN: {
                        this.report(new UnsupportedFeatureException((PMMLObject)segmentation, (Enum)multipleModelMethod));
                        break block0;
                    }
                }
                break;
            }
        }
        return super.visit(miningModel);
    }

    public VisitorAction visit(NearestNeighborModel nearestNeighborModel) {
        ContinuousScoringMethodType continuousScoringMethod = nearestNeighborModel.getContinuousScoringMethod();
        switch (continuousScoringMethod) {
            case MEDIAN: {
                this.report(new UnsupportedFeatureException((PMMLObject)nearestNeighborModel, (Enum)continuousScoringMethod));
                break;
            }
        }
        return super.visit(nearestNeighborModel);
    }

    public VisitorAction visit(NeuralNetwork neuralNetwork) {
        ActivationFunctionType activationFunction = neuralNetwork.getActivationFunction();
        switch (activationFunction) {
            case RADIAL_BASIS: {
                this.report(new UnsupportedFeatureException((PMMLObject)neuralNetwork, (Enum)activationFunction));
                break;
            }
        }
        return super.visit(neuralNetwork);
    }

    public VisitorAction visit(NeuralLayer neuralLayer) {
        ActivationFunctionType activationFunction = neuralLayer.getActivationFunction();
        switch (activationFunction) {
            case RADIAL_BASIS: {
                this.report(new UnsupportedFeatureException((PMMLObject)neuralLayer, (Enum)activationFunction));
                break;
            }
        }
        return super.visit(neuralLayer);
    }

    public VisitorAction visit(NormDiscrete normDiscrete) {
        NormDiscrete.Method method = normDiscrete.getMethod();
        switch (method) {
            case THERMOMETER: {
                this.report(new UnsupportedFeatureException((PMMLObject)normDiscrete, (Enum)method));
                break;
            }
        }
        return super.visit(normDiscrete);
    }

    public VisitorAction visit(OutputField outputField) {
        ResultFeatureType resultFeature = outputField.getFeature();
        switch (resultFeature) {
            case STANDARD_ERROR: {
                this.report(new UnsupportedFeatureException((PMMLObject)outputField, (Enum)resultFeature));
                break;
            }
        }
        return super.visit(outputField);
    }

    public VisitorAction visit(Predictor predictor) {
        Categories categories;
        Matrix matrix = predictor.getMatrix();
        if (matrix != null && (categories = predictor.getCategories()) == null) {
            this.report(new UnsupportedFeatureException((PMMLObject)predictor));
        }
        return super.visit(predictor);
    }

    public VisitorAction visit(Regression regression) {
        this.report(new UnsupportedFeatureException((PMMLObject)regression));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(Segmentation segmentation) {
        LocalTransformations localTransformations = segmentation.getLocalTransformations();
        if (localTransformations != null) {
            this.report(new UnsupportedFeatureException((PMMLObject)localTransformations));
        }
        return super.visit(segmentation);
    }

    public VisitorAction visit(SequenceModel sequenceModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)sequenceModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel) {
        SvmRepresentationType svmRepresentation = supportVectorMachineModel.getSvmRepresentation();
        switch (svmRepresentation) {
            case COEFFICIENTS: {
                this.report(new UnsupportedFeatureException((PMMLObject)supportVectorMachineModel, (Enum)svmRepresentation));
                break;
            }
        }
        return super.visit(supportVectorMachineModel);
    }

    public VisitorAction visit(TableLocator tableLocator) {
        this.report(new UnsupportedFeatureException((PMMLObject)tableLocator));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TargetValueStat targetValueStat) {
        ContinuousDistribution continuousDistribution = targetValueStat.getContinuousDistribution();
        if (!(continuousDistribution instanceof GaussianDistribution)) {
            this.report(new UnsupportedFeatureException((PMMLObject)continuousDistribution));
        }
        return super.visit(targetValueStat);
    }

    public VisitorAction visit(TextModel textModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)textModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TimeSeriesModel timeSeriesModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)timeSeriesModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TreeModel treeModel) {
        MissingValueStrategyType missingValueStrategy = treeModel.getMissingValueStrategy();
        switch (missingValueStrategy) {
            case AGGREGATE_NODES: 
            case WEIGHTED_CONFIDENCE: {
                this.report(new UnsupportedFeatureException((PMMLObject)treeModel, (Enum)missingValueStrategy));
                break;
            }
        }
        return super.visit(treeModel);
    }

    private void report(UnsupportedFeatureException exception) {
        this.exceptions.add(exception);
    }

    public List<UnsupportedFeatureException> getExceptions() {
        return this.exceptions;
    }
}

