/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.LocalEvaluationContext;
import org.jpmml.evaluator.TypeUtil;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionUtilTest {
    @Test
    public void evaluateConstant() {
        Constant constant = new Constant("3").withDataType(DataType.STRING);
        Assert.assertEquals((Object)"3", (Object)ExpressionUtilTest.evaluate((Expression)constant));
        Constant integerThree = new Constant("3").withDataType(DataType.INTEGER);
        Assert.assertEquals((Object)3, (Object)ExpressionUtilTest.evaluate((Expression)integerThree));
        Constant floatThree = new Constant("3").withDataType(DataType.FLOAT);
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)ExpressionUtilTest.evaluate((Expression)floatThree));
    }

    @Test
    public void evaluateFieldRef() {
        FieldName name = new FieldName("x");
        FieldRef fieldRef = new FieldRef(name);
        Assert.assertEquals((Object)"3", (Object)ExpressionUtilTest.evaluate((Expression)fieldRef, name, "3"));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)fieldRef, name, null));
        fieldRef = fieldRef.withMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtilTest.evaluate((Expression)fieldRef, name, null));
    }

    @Test
    public void evaluateNormContinuous() {
        FieldName name = new FieldName("x");
        NormContinuous normContinuous = new NormContinuous(name, null).withMapMissingTo(Double.valueOf(5.0));
        Assert.assertEquals((Object)5.0, (Object)ExpressionUtilTest.evaluate((Expression)normContinuous, name, null));
    }

    @Test
    public void evaluateNormDiscrete() {
        FieldName name = new FieldName("x");
        Double equals = 1.0;
        Double notEquals = 0.0;
        NormDiscrete stringThree = new NormDiscrete(name, "3");
        Assert.assertEquals((Object)equals, (Object)ExpressionUtilTest.evaluate((Expression)stringThree, name, "3"));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtilTest.evaluate((Expression)stringThree, name, "1"));
        stringThree = stringThree.withMapMissingTo(Double.valueOf(5.0));
        Assert.assertEquals((Object)5.0, (Object)ExpressionUtilTest.evaluate((Expression)stringThree, name, null));
        NormDiscrete integerThree = new NormDiscrete(name, "3");
        Assert.assertEquals((Object)equals, (Object)ExpressionUtilTest.evaluate((Expression)integerThree, name, 3));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtilTest.evaluate((Expression)integerThree, name, 1));
        NormDiscrete floatThree = new NormDiscrete(name, "3.0");
        Assert.assertEquals((Object)equals, (Object)ExpressionUtilTest.evaluate((Expression)floatThree, name, Float.valueOf(3.0f)));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtilTest.evaluate((Expression)floatThree, name, Float.valueOf(1.0f)));
    }

    @Test
    public void evaluateDiscretize() {
        FieldName name = new FieldName("x");
        Discretize discretize = new Discretize(name);
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)discretize));
        discretize = discretize.withMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtilTest.evaluate((Expression)discretize));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)discretize, name, 3));
        discretize = discretize.withDefaultValue("Default");
        Assert.assertEquals((Object)"Default", (Object)ExpressionUtilTest.evaluate((Expression)discretize, name, 3));
    }

    @Test
    public void evaluateMapValues() {
        FieldName name = new FieldName("x");
        MapValues mapValues = new MapValues(null).withFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(name, null)});
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)mapValues));
        mapValues = mapValues.withMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtilTest.evaluate((Expression)mapValues));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)mapValues, name, "3"));
        mapValues = mapValues.withDefaultValue("Default");
        Assert.assertEquals((Object)"Default", (Object)ExpressionUtilTest.evaluate((Expression)mapValues, name, "3"));
    }

    @Test
    public void evaluateApply() {
        FieldName name = new FieldName("x");
        Apply apply = new Apply("/").withExpressions(new Expression[]{new FieldRef(name), new Constant("0")});
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)apply, name, null));
        apply = apply.withDefaultValue("-1");
        Assert.assertEquals((Object)"-1", (Object)ExpressionUtilTest.evaluate((Expression)apply, name, null));
        apply = apply.withMapMissingTo("missing");
        Assert.assertEquals((Object)"missing", (Object)ExpressionUtilTest.evaluate((Expression)apply, name, null));
        apply = apply.withInvalidValueTreatment(InvalidValueTreatmentMethodType.RETURN_INVALID);
        try {
            ExpressionUtilTest.evaluate((Expression)apply, name, 1);
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        apply = apply.withInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        try {
            ExpressionUtilTest.evaluate((Expression)apply, name, 1);
            Assert.fail();
        }
        catch (InvalidResultException invalidResultException) {
            // empty catch block
        }
        apply = apply.withInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)"-1", (Object)ExpressionUtilTest.evaluate((Expression)apply, name, 1));
    }

    @Test
    public void evaluateApplyCondition() {
        FieldName name = new FieldName("x");
        Apply condition = new Apply("isNotMissing").withExpressions(new Expression[]{new FieldRef(name)});
        Apply apply = new Apply("if").withExpressions(new Expression[]{condition});
        try {
            ExpressionUtilTest.evaluate((Expression)apply, name, null);
            Assert.fail();
        }
        catch (FunctionException fe) {
            // empty catch block
        }
        Apply thenPart = new Apply("abs").withExpressions(new Expression[]{new FieldRef(name)});
        apply = apply.withExpressions(new Expression[]{thenPart});
        Assert.assertEquals((Object)1, (Object)ExpressionUtilTest.evaluate((Expression)apply, name, 1));
        Assert.assertEquals((Object)1, (Object)ExpressionUtilTest.evaluate((Expression)apply, name, -1));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)apply, name, null));
        Constant elsePart = new Constant("-1").withDataType(DataType.DOUBLE);
        apply = apply.withExpressions(new Expression[]{elsePart});
        Assert.assertEquals((Object)-1.0, (Object)ExpressionUtilTest.evaluate((Expression)apply, name, null));
        apply = apply.withExpressions(new Expression[]{new FieldRef(name)});
        try {
            ExpressionUtilTest.evaluate((Expression)apply, name, null);
            Assert.fail();
        }
        catch (FunctionException fe) {
            // empty catch block
        }
    }

    @Test
    public void evaluateAggregate() {
        FieldName name = new FieldName("x");
        List<Object> values = Arrays.asList(TypeUtil.parse((DataType)DataType.DATE, (String)"2013-01-01"), TypeUtil.parse((DataType)DataType.DATE, (String)"2013-02-01"), TypeUtil.parse((DataType)DataType.DATE, (String)"2013-03-01"));
        Aggregate aggregate = new Aggregate(name, Aggregate.Function.COUNT);
        Assert.assertEquals((Object)3, (Object)ExpressionUtilTest.evaluate((Expression)aggregate, name, values));
        aggregate = aggregate.withFunction(Aggregate.Function.MIN);
        Assert.assertEquals((Object)values.get(0), (Object)ExpressionUtilTest.evaluate((Expression)aggregate, name, values));
        aggregate = aggregate.withFunction(Aggregate.Function.MAX);
        Assert.assertEquals((Object)values.get(2), (Object)ExpressionUtilTest.evaluate((Expression)aggregate, name, values));
    }

    private static Object evaluate(Expression expression) {
        Map arguments = Collections.emptyMap();
        return ExpressionUtilTest.evaluate(expression, arguments);
    }

    private static Object evaluate(Expression expression, FieldName field, Object value) {
        Map<FieldName, Object> arguments = Collections.singletonMap(field, value);
        return ExpressionUtilTest.evaluate(expression, arguments);
    }

    private static Object evaluate(Expression expression, Map<FieldName, ?> arguments) {
        LocalEvaluationContext context = new LocalEvaluationContext();
        context.declareAll(arguments);
        FieldValue result = ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)context);
        return FieldValueUtil.getValue((FieldValue)result);
    }
}

