/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.ClusteringField;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.Measure;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.Tanimoto;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.MeasureUtil;
import org.junit.Assert;
import org.junit.Test;

public class MeasureUtilTest {
    @Test
    public void evaluateSimilarity() {
        List<ClusteringField> clusteringFields = MeasureUtilTest.createClusteringFields("one", "two", "three", "four");
        BitSet flags = MeasureUtilTest.createFlags(0, 0, 1, 1);
        BitSet referenceFlags = MeasureUtilTest.createFlags(0, 1, 0, 1);
        ComparisonMeasure comparisonMeasure = new ComparisonMeasure(ComparisonMeasure.Kind.SIMILARITY);
        comparisonMeasure = comparisonMeasure.withMeasure((Measure)new SimpleMatching());
        Assert.assertEquals((double)0.5, (double)MeasureUtil.evaluateSimilarity((ComparisonMeasure)comparisonMeasure, clusteringFields, (BitSet)flags, (BitSet)referenceFlags), (double)1.0E-8);
        comparisonMeasure = comparisonMeasure.withMeasure((Measure)new Jaccard());
        Assert.assertEquals((double)0.3333333333333333, (double)MeasureUtil.evaluateSimilarity((ComparisonMeasure)comparisonMeasure, clusteringFields, (BitSet)flags, (BitSet)referenceFlags), (double)1.0E-8);
        comparisonMeasure = comparisonMeasure.withMeasure((Measure)new Tanimoto());
        Assert.assertEquals((double)0.3333333333333333, (double)MeasureUtil.evaluateSimilarity((ComparisonMeasure)comparisonMeasure, clusteringFields, (BitSet)flags, (BitSet)referenceFlags), (double)1.0E-8);
        comparisonMeasure = comparisonMeasure.withMeasure((Measure)new BinarySimilarity(0.5, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0));
        Assert.assertEquals((double)0.5, (double)MeasureUtil.evaluateSimilarity((ComparisonMeasure)comparisonMeasure, clusteringFields, (BitSet)flags, (BitSet)referenceFlags), (double)1.0E-8);
    }

    private static List<ClusteringField> createClusteringFields(String ... names) {
        ArrayList result = Lists.newArrayList();
        for (String name : names) {
            result.add(new ClusteringField(new FieldName(name)));
        }
        return result;
    }

    private static BitSet createFlags(Number ... numbers) {
        ArrayList result = Lists.newArrayList();
        for (Number number : numbers) {
            result.add(FieldValueUtil.create((Object)number));
        }
        return MeasureUtil.toBitSet((List)result);
    }
}

