/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.ProbabilityAggregator;
import org.jpmml.evaluator.ProbabilityClassificationMap;
import org.junit.Assert;
import org.junit.Test;

public class ProbabilityAggregatorTest {
    @Test
    public void max() {
        ProbabilityAggregator aggregator = new ProbabilityAggregator();
        aggregator.max((HasProbability)ProbabilityAggregatorTest.createClassificationMap(1.0, 3.0));
        Assert.assertEquals((Object)1.0, (Object)aggregator.get((Object)"A"));
        Assert.assertEquals((Object)3.0, (Object)aggregator.get((Object)"B"));
        aggregator.max((HasProbability)ProbabilityAggregatorTest.createClassificationMap(3.0, 1.0));
        Assert.assertEquals((Object)3.0, (Object)aggregator.get((Object)"A"));
        Assert.assertEquals((Object)3.0, (Object)aggregator.get((Object)"B"));
    }

    @Test
    public void sum() {
        ProbabilityAggregator aggregator = new ProbabilityAggregator();
        aggregator.sum((HasProbability)ProbabilityAggregatorTest.createClassificationMap(1.0, 3.0));
        Assert.assertEquals((Object)1.0, (Object)aggregator.get((Object)"A"));
        Assert.assertEquals((Object)3.0, (Object)aggregator.get((Object)"B"));
        aggregator.sum((HasProbability)ProbabilityAggregatorTest.createClassificationMap(3.0, 1.0), 0.5);
        double sumA = 2.5;
        double sumB = 3.5;
        Assert.assertEquals((Object)sumA, (Object)aggregator.get((Object)"A"));
        Assert.assertEquals((Object)sumB, (Object)aggregator.get((Object)"B"));
        aggregator.divide(Double.valueOf(1.5));
        double denominator = 1.5;
        Assert.assertEquals((Object)(sumA / denominator), (Object)aggregator.get((Object)"A"));
        Assert.assertEquals((Object)(sumB / denominator), (Object)aggregator.get((Object)"B"));
    }

    private static ProbabilityClassificationMap createClassificationMap(Double a, Double b) {
        ProbabilityClassificationMap result = new ProbabilityClassificationMap();
        result.put((Object)"A", (Object)a);
        result.put((Object)"B", (Object)b);
        return result;
    }
}

