/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Map;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.ProbabilityAggregator;
import org.jpmml.evaluator.ProbabilityClassificationMap;
import org.junit.Assert;
import org.junit.Test;

public class ProbabilityAggregatorTest {
    @Test
    public void add() {
        ProbabilityAggregator aggregator = new ProbabilityAggregator();
        aggregator.add(ProbabilityAggregatorTest.createClassificationMap(1.0, 3.0));
        Map maxMap = aggregator.maxMap();
        Assert.assertEquals((Object)1.0, maxMap.get("A"));
        Assert.assertEquals((Object)3.0, maxMap.get("B"));
        aggregator.add(ProbabilityAggregatorTest.createClassificationMap(3.0, 1.0), 0.5);
        maxMap = aggregator.maxMap();
        Assert.assertEquals((Object)1.5, maxMap.get("A"));
        Assert.assertEquals((Object)3.0, maxMap.get("B"));
        double denominator = 1.5;
        Map averageMap = aggregator.averageMap(denominator);
        double sumA = 2.5;
        double sumB = 3.5;
        Assert.assertEquals((Object)(sumA / denominator), averageMap.get("A"));
        Assert.assertEquals((Object)(sumB / denominator), averageMap.get("B"));
        Assert.assertEquals((long)2L, (long)aggregator.size());
    }

    private static HasProbability createClassificationMap(Double a, Double b) {
        ProbabilityClassificationMap result = new ProbabilityClassificationMap();
        result.put((Object)"A", (Object)a);
        result.put((Object)"B", (Object)b);
        return result;
    }
}

