/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.CategoricalValue;
import org.jpmml.evaluator.ContinuousValue;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.OrdinalValue;
import org.jpmml.evaluator.TypeUtil;

public class FieldValueUtil {
    private FieldValueUtil() {
    }

    public static FieldValue create(Object value) {
        return FieldValueUtil.create((DataType)null, (OpType)null, value);
    }

    public static FieldValue create(Field field, Object value) {
        FieldValue result = FieldValueUtil.create(field.getDataType(), field.getOpType(), value);
        if (field instanceof TypeDefinitionField) {
            return FieldValueUtil.enhance((TypeDefinitionField)field, result);
        }
        return result;
    }

    public static FieldValue create(DataField dataField, MiningField miningField, Object value) {
        DataType dataType = dataField.getDataType();
        OpType opType = miningField.getOpType();
        if (opType == null) {
            opType = dataField.getOpType();
        }
        return FieldValueUtil.create(dataType, opType, value);
    }

    public static FieldValue create(DataType dataType, OpType opType, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            if (dataType == null) {
                dataType = DataType.STRING;
            }
            if (opType == null) {
                opType = OpType.CATEGORICAL;
            }
        } else {
            if (dataType == null) {
                dataType = TypeUtil.getDataType(value);
            } else {
                value = TypeUtil.parseOrCast(dataType, value);
            }
            if (opType == null) {
                opType = TypeUtil.getOpType(dataType);
            }
        }
        switch (opType) {
            case CONTINUOUS: {
                return new ContinuousValue(dataType, value);
            }
            case CATEGORICAL: {
                return new CategoricalValue(dataType, value);
            }
            case ORDINAL: {
                return new OrdinalValue(dataType, value);
            }
        }
        throw new EvaluationException();
    }

    public static FieldValue refine(Field field, FieldValue value) {
        FieldValue result = FieldValueUtil.refine(field.getDataType(), field.getOpType(), value);
        if (field instanceof TypeDefinitionField) {
            return FieldValueUtil.enhance((TypeDefinitionField)field, result);
        }
        return result;
    }

    public static FieldValue refine(DataType dataType, OpType opType, FieldValue value) {
        boolean refined;
        if (value == null) {
            return null;
        }
        DataType refinedDataType = null;
        if (dataType != null && !dataType.equals((Object)value.getDataType())) {
            refinedDataType = dataType;
        }
        OpType refinedOpType = null;
        if (opType != null && !opType.equals((Object)value.getOpType())) {
            refinedOpType = opType;
        }
        boolean bl = refined = refinedDataType != null || refinedOpType != null;
        if (refined) {
            return FieldValueUtil.create(refinedDataType, refinedOpType, value.getValue());
        }
        return value;
    }

    public static FieldValue enhance(TypeDefinitionField field, FieldValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof OrdinalValue) {
            OrdinalValue ordinalValue = (OrdinalValue)value;
            ordinalValue.setOrdering(FieldValueUtil.getOrdering(field, ordinalValue.getDataType()));
        }
        return value;
    }

    public static Object getValue(FieldValue value) {
        return value != null ? value.getValue() : null;
    }

    private static List<?> getOrdering(TypeDefinitionField field, final DataType dataType) {
        List<Value> values = ArgumentUtil.getValidValues(field);
        if (values.isEmpty()) {
            return null;
        }
        Function<Value, Object> function = new Function<Value, Object>(){

            public Object apply(Value value) {
                return TypeUtil.parse(dataType, value.getValue());
            }
        };
        return Lists.newArrayList((Iterable)Iterables.transform(values, (Function)function));
    }
}

