/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.HasAffinityRanking;
import org.jpmml.evaluator.HasEntityAffinity;
import org.jpmml.evaluator.HasEntityIdRanking;

@Beta
public class InstanceClassificationMap
extends ClassificationMap<String>
implements HasEntityIdRanking,
HasAffinityRanking,
HasEntityAffinity {
    private Object result = null;

    protected InstanceClassificationMap(ClassificationMap.Type type, Object result) {
        super(type);
        Preconditions.checkArgument((ClassificationMap.Type.DISTANCE.equals(type) || ClassificationMap.Type.SIMILARITY.equals(type) ? 1 : 0) != 0);
        this.setResult(result);
    }

    @Override
    public Object getResult() {
        if (this.result == null) {
            throw new EvaluationException();
        }
        return this.result;
    }

    private void setResult(Object result) {
        this.result = result;
    }

    @Override
    public Set<String> getCategoryValues() {
        return this.keySet();
    }

    @Override
    public String getEntityId() {
        Map.Entry entry = this.getWinner();
        if (entry == null) {
            return null;
        }
        return (String)entry.getKey();
    }

    @Override
    public List<String> getEntityIdRanking() {
        return this.getWinnerKeys();
    }

    @Override
    public Double getAffinity(String id) {
        return this.getFeature(id);
    }

    @Override
    public List<Double> getAffinityRanking() {
        return this.getWinnerValues();
    }

    @Override
    public Double getEntityAffinity() {
        return this.getAffinity(this.getEntityId());
    }
}

