/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.VerificationFields;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.VerificationUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.ModelManager;

public abstract class ModelEvaluator<M extends Model>
extends ModelManager<M>
implements Evaluator {
    private static final EnumSet<FieldUsageType> FILTER_SET = EnumSet.of(FieldUsageType.ACTIVE, FieldUsageType.GROUP, FieldUsageType.ORDER);

    public ModelEvaluator(PMML pmml, M model) {
        super(pmml, model);
    }

    public abstract Map<FieldName, ?> evaluate(ModelEvaluationContext var1);

    public DataField getDataField(FieldName name) {
        if (name == null) {
            return this.getDataField();
        }
        return super.getDataField(name);
    }

    protected DataField getDataField() {
        Model model = this.getModel();
        MiningFunctionType miningFunction = model.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                return new DataField(null, OpType.CONTINUOUS, DataType.DOUBLE);
            }
            case CLASSIFICATION: 
            case CLUSTERING: {
                return new DataField(null, OpType.CATEGORICAL, DataType.STRING);
            }
        }
        return null;
    }

    @Override
    public FieldValue prepare(FieldName name, Object value) {
        DataField dataField = this.getDataField(name);
        MiningField miningField = this.getMiningField(name);
        if (dataField == null || miningField == null) {
            throw new EvaluationException();
        }
        return ArgumentUtil.prepare(dataField, miningField, value);
    }

    @Override
    public void verify() {
        Model model = this.getModel();
        ModelVerification modelVerification = model.getModelVerification();
        if (modelVerification == null) {
            return;
        }
        VerificationFields verificationFields = modelVerification.getVerificationFields();
        if (verificationFields == null) {
            throw new InvalidFeatureException((PMMLObject)modelVerification);
        }
        LinkedHashMap fieldMap = Maps.newLinkedHashMap();
        for (VerificationField verificationField : verificationFields) {
            fieldMap.put(FieldName.create((String)verificationField.getField()), verificationField);
        }
        InlineTable inlineTable = modelVerification.getInlineTable();
        if (inlineTable == null) {
            throw new InvalidFeatureException((PMMLObject)modelVerification);
        }
        Table<Integer, String, String> table = InlineTableUtil.getContent(inlineTable);
        List<Object> records = Lists.newArrayList();
        Set rowKeys = table.rowKeySet();
        for (Integer rowKey : rowKeys) {
            Map row = table.row((Object)rowKey);
            LinkedHashMap record = Maps.newLinkedHashMap();
            for (VerificationField verificationField : verificationFields) {
                String string = verificationField.getField();
                String column = verificationField.getColumn();
                if (column == null) {
                    column = string;
                }
                if (!row.containsKey(column)) continue;
                record.put(FieldName.create((String)string), row.get(column));
            }
            records.add(record);
        }
        Integer recordCount = modelVerification.getRecordCount();
        if (recordCount != null && recordCount.intValue() != records.size()) {
            throw new InvalidFeatureException((PMMLObject)inlineTable);
        }
        List activeFields = this.getActiveFields();
        List groupFields = this.getGroupFields();
        if (groupFields.size() == 1) {
            FieldName groupField = (FieldName)groupFields.get(0);
            records = EvaluatorUtil.groupRows(groupField, records);
        } else if (groupFields.size() > 1) {
            throw new EvaluationException();
        }
        List targetFields = this.getTargetFields();
        List outputFields = this.getOutputFields();
        for (Map map : records) {
            VerificationField verificationField;
            LinkedHashMap arguments = Maps.newLinkedHashMap();
            for (FieldName activeField : activeFields) {
                arguments.put(activeField, EvaluatorUtil.prepare(this, activeField, map.get(activeField)));
            }
            Map<FieldName, ?> result = this.evaluate(arguments);
            Sets.SetView intersection = Sets.intersection(map.keySet(), (Set)ImmutableSet.copyOf((Collection)outputFields));
            if (intersection.size() > 0) {
                for (FieldName outputField : outputFields) {
                    verificationField = (VerificationField)fieldMap.get(outputField);
                    if (verificationField == null) continue;
                    this.verify(map.get(outputField), result.get(outputField), verificationField.getPrecision(), verificationField.getZeroThreshold());
                }
                continue;
            }
            for (FieldName targetField : targetFields) {
                verificationField = (VerificationField)fieldMap.get(targetField);
                if (verificationField == null) continue;
                this.verify(map.get(targetField), EvaluatorUtil.decode(result.get(targetField)), verificationField.getPrecision(), verificationField.getZeroThreshold());
            }
        }
    }

    private void verify(Object expected, Object actual, double precision, double zeroThreshold) {
        boolean acceptable;
        if (expected == null) {
            return;
        }
        if (!(actual instanceof Collection)) {
            DataType dataType = TypeUtil.getDataType(actual);
            expected = TypeUtil.parseOrCast(dataType, expected);
        }
        if (!(acceptable = VerificationUtil.acceptable(expected, actual, precision, zeroThreshold))) {
            throw new EvaluationException();
        }
    }

    public ModelEvaluationContext createContext(ModelEvaluationContext parent) {
        return new ModelEvaluationContext(parent, this);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        List filterFields = this.getMiningFields(FILTER_SET);
        ModelEvaluationContext context = this.createContext(null);
        context.declareAll(filterFields, arguments);
        return this.evaluate(context);
    }

    public <V> V getValue(LoadingCache<M, V> cache) {
        Model model = this.getModel();
        return CacheUtil.getValue(model, cache);
    }

    public <V> V getValue(Callable<? extends V> loader, Cache<M, V> cache) {
        Model model = this.getModel();
        return CacheUtil.getValue(model, loader, cache);
    }
}

