/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

class RegressionAggregator {
    private List<Double> values = Lists.newArrayList();

    RegressionAggregator() {
    }

    public int size() {
        return this.values.size();
    }

    public void clear() {
        this.values.clear();
    }

    public void add(Double value) {
        this.values.add(value);
    }

    public Double sum() {
        Function<List<Double>, Double> function = new Function<List<Double>, Double>(){

            public Double apply(List<Double> values) {
                return RegressionAggregator.sum(values);
            }
        };
        return this.transform(function);
    }

    public Double median() {
        Function<List<Double>, Double> function = new Function<List<Double>, Double>(){

            public Double apply(List<Double> values) {
                return RegressionAggregator.median(values);
            }
        };
        return this.transform(function);
    }

    public Double average(final double denominator) {
        Function<List<Double>, Double> function = new Function<List<Double>, Double>(){

            public Double apply(List<Double> values) {
                return RegressionAggregator.sum(values) / denominator;
            }
        };
        return this.transform(function);
    }

    protected Double transform(Function<List<Double>, Double> function) {
        return (Double)function.apply(this.values);
    }

    static double sum(List<Double> values) {
        double result = 0.0;
        for (Double value : values) {
            result += value.doubleValue();
        }
        return result;
    }

    static double median(List<Double> values) {
        double[] data = Doubles.toArray(values);
        Arrays.sort(data);
        Percentile percentile = new Percentile();
        percentile.setData(data);
        return percentile.evaluate(50.0);
    }
}

