/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.EvaluatorUtil;
import org.junit.Assert;
import org.junit.Test;

public class EvaluatorUtilTest {
    @Test
    public void decode() {
        Computable value = new Computable(){

            public String getResult() {
                return "value";
            }
        };
        Assert.assertEquals((Object)"value", (Object)EvaluatorUtil.decode((Object)value));
        Assert.assertEquals(Arrays.asList("value"), (Object)EvaluatorUtil.decode(Arrays.asList(value)));
        Assert.assertEquals(Arrays.asList("value", "value"), (Object)EvaluatorUtil.decode(Arrays.asList(value, value)));
    }

    @Test
    public void groupRows() {
        List table = Lists.newArrayList();
        table.add(EvaluatorUtilTest.createRow("1", "Cracker"));
        table.add(EvaluatorUtilTest.createRow("2", "Cracker"));
        table.add(EvaluatorUtilTest.createRow("1", "Coke"));
        table.add(EvaluatorUtilTest.createRow("3", "Cracker"));
        table.add(EvaluatorUtilTest.createRow("3", "Water"));
        table.add(EvaluatorUtilTest.createRow("3", "Coke"));
        table.add(EvaluatorUtilTest.createRow("2", "Water"));
        table = EvaluatorUtil.groupRows((Object)new FieldName("transaction"), (List)table);
        EvaluatorUtilTest.checkGroupedRow((Map)table.get(0), "1", Arrays.asList("Cracker", "Coke"));
        EvaluatorUtilTest.checkGroupedRow((Map)table.get(1), "2", Arrays.asList("Cracker", "Water"));
        EvaluatorUtilTest.checkGroupedRow((Map)table.get(2), "3", Arrays.asList("Cracker", "Water", "Coke"));
    }

    private static Map<FieldName, Object> createRow(String transaction, String item) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.put(new FieldName("transaction"), transaction);
        result.put(new FieldName("item"), item);
        return result;
    }

    private static void checkGroupedRow(Map<FieldName, Object> row, String transaction, List<String> items) {
        Assert.assertEquals((long)2L, (long)row.size());
        Assert.assertEquals((Object)transaction, (Object)row.get(new FieldName("transaction")));
        Assert.assertEquals(items, (Object)row.get(new FieldName("item")));
    }
}

