/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import org.dmg.pmml.PMMLObject;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.PMMLException;

public class CacheUtil {
    private CacheUtil() {
    }

    public static <K extends PMMLObject, V> V getValue(K key, LoadingCache<K, V> cache) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException uee) {
            Throwable cause = uee.getCause();
            if (cause instanceof PMMLException) {
                throw (PMMLException)cause;
            }
            throw new InvalidFeatureException(key);
        }
    }
}

