/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.DuplicateFieldException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;

public abstract class EvaluationContext {
    private Map<FieldName, FieldValue> fields = Maps.newLinkedHashMap();
    private List<String> warnings = Lists.newArrayList();

    public abstract DerivedField resolveDerivedField(FieldName var1);

    public abstract DefineFunction resolveFunction(String var1);

    public FieldValue getField(FieldName name) {
        Map.Entry<FieldName, FieldValue> entry = this.getFieldEntry(name);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<FieldName, FieldValue> getFieldEntry(FieldName name) {
        Map<FieldName, FieldValue> fields = this.getFields();
        if (fields.containsKey(name)) {
            AbstractMap.SimpleEntry<FieldName, FieldValue> entry = new AbstractMap.SimpleEntry<FieldName, FieldValue>(name, fields.get(name));
            return entry;
        }
        return null;
    }

    public void declare(FieldName name, Object value) {
        if (value instanceof FieldValue) {
            this.declare(name, (FieldValue)value);
            return;
        }
        this.declare(name, this.createFieldValue(name, value));
    }

    public void declare(FieldName name, FieldValue value) {
        Map<FieldName, FieldValue> fields = this.getFields();
        boolean declared = fields.containsKey(name);
        if (declared) {
            throw new DuplicateFieldException(name);
        }
        fields.put(name, value);
    }

    public void declareAll(Map<FieldName, ?> fields) {
        Set<Map.Entry<FieldName, ?>> entries = fields.entrySet();
        for (Map.Entry entry : entries) {
            this.declare((FieldName)entry.getKey(), entry.getValue());
        }
    }

    public FieldValue createFieldValue(FieldName name, Object value) {
        return FieldValueUtil.create(value);
    }

    public void addWarning(String warning) {
        List<String> warnings = this.getWarnings();
        warnings.add(warning);
    }

    public Map<FieldName, FieldValue> getFields() {
        return this.fields;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }
}

