/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import com.google.common.base.Preconditions;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;

public abstract class AbstractFunction
implements Function {
    private String name = null;

    public AbstractFunction(String name) {
        this.setName(name);
    }

    protected void checkArguments(List<FieldValue> values, int size) {
        this.checkArguments(values, size, false);
    }

    protected void checkArguments(List<FieldValue> values, int size, boolean allowNulls) {
        if (values.size() != size) {
            throw new FunctionException(this.getName(), "Expected " + size + " arguments, but got " + values.size() + " arguments");
        }
        if (!allowNulls && values.contains(null)) {
            throw new FunctionException(this.getName(), "Missing arguments");
        }
    }

    protected void checkVariableArguments(List<FieldValue> values, int size) {
        this.checkVariableArguments(values, size, false);
    }

    protected void checkVariableArguments(List<FieldValue> values, int size, boolean allowNulls) {
        if (values.size() < size) {
            throw new FunctionException(this.getName(), "Expected " + size + " or more arguments, but got " + values.size() + " arguments");
        }
        if (!allowNulls && values.contains(null)) {
            throw new FunctionException(this.getName(), "Missing arguments");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    protected static Number cast(DataType dataType, Number number) {
        switch (dataType) {
            case INTEGER: {
                if (number instanceof Integer) {
                    return number;
                }
                return number.intValue();
            }
            case FLOAT: {
                if (number instanceof Float) {
                    return number;
                }
                return Float.valueOf(number.floatValue());
            }
            case DOUBLE: {
                if (number instanceof Double) {
                    return number;
                }
                return number.doubleValue();
            }
        }
        throw new EvaluationException();
    }

    protected static DataType integerToDouble(DataType dataType) {
        switch (dataType) {
            case INTEGER: {
                return DataType.DOUBLE;
            }
        }
        return dataType;
    }
}

