/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;

public abstract class ArithmeticFunction
extends AbstractFunction {
    public ArithmeticFunction(String name) {
        super(name);
    }

    public abstract Number evaluate(Number var1, Number var2);

    @Override
    public FieldValue evaluate(List<FieldValue> values) {
        Number result;
        this.checkArguments(values, 2, true);
        FieldValue left = values.get(0);
        FieldValue right = values.get(1);
        if (left == null || right == null) {
            return null;
        }
        DataType dataType = TypeUtil.getResultDataType(left.getDataType(), right.getDataType());
        try {
            result = this.evaluate(left.asNumber(), right.asNumber());
        }
        catch (ArithmeticException ae) {
            throw new InvalidResultException(null);
        }
        return FieldValueUtil.create(ArithmeticFunction.cast(dataType, result));
    }
}

