/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.OrdinalValue;
import org.junit.Assert;
import org.junit.Test;

public class FieldValueTest {
    @Test
    public void categoricalString() {
        FieldValue zero = FieldValueUtil.create((DataType)DataType.STRING, (OpType)OpType.CATEGORICAL, (Object)"0");
        FieldValue one = FieldValueUtil.create((DataType)DataType.STRING, (OpType)OpType.CATEGORICAL, (Object)"1");
        Assert.assertEquals((Object)0, (Object)zero.asInteger());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)zero.asBoolean());
        Assert.assertEquals((Object)1, (Object)one.asInteger());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)one.asBoolean());
    }

    @Test
    public void ordinalString() {
        OrdinalValue loud = new OrdinalValue(DataType.STRING, (Object)"loud");
        OrdinalValue louder = new OrdinalValue(DataType.STRING, (Object)"louder");
        OrdinalValue insane = new OrdinalValue(DataType.STRING, (Object)"insane");
        Assert.assertTrue((boolean)louder.equalsString("louder"));
        Assert.assertTrue((boolean)louder.equalsValue(FieldValueUtil.create((DataType)DataType.STRING, (OpType)OpType.CATEGORICAL, (Object)"louder")));
        Assert.assertTrue((boolean)louder.equalsValue(FieldValueUtil.create((DataType)DataType.STRING, (OpType)OpType.ORDINAL, (Object)"louder")));
        louder.setOrdering(null);
        Assert.assertTrue((louder.compareToString("loud") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("louder") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("insane") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)loud) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)louder) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)insane) > 0 ? 1 : 0) != 0);
        louder.setOrdering(Arrays.asList("loud", "louder", "insane"));
        Assert.assertTrue((louder.compareToString("loud") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("louder") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToString("insane") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)loud) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)louder) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((louder.compareToValue((FieldValue)insane) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void continuousInteger() {
        FieldValue zero = FieldValueUtil.create((DataType)DataType.INTEGER, (OpType)OpType.CONTINUOUS, (Object)0);
        Assert.assertTrue((zero.compareToString("-1") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("-1.5") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("1") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("1.5") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void categoricalInteger() {
        FieldValue zero = FieldValueUtil.create((DataType)DataType.INTEGER, (OpType)OpType.CATEGORICAL, (Object)0);
        try {
            zero.compareToString("0");
            Assert.fail();
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
    }

    @Test
    public void categoricalBoolean() {
        FieldValue zero = FieldValueUtil.create((DataType)DataType.BOOLEAN, (OpType)OpType.CATEGORICAL, (Object)false);
        FieldValue one = FieldValueUtil.create((DataType)DataType.BOOLEAN, (OpType)OpType.CATEGORICAL, (Object)true);
        Assert.assertTrue((zero.compareToString("0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("0.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((zero.compareToString("1") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("1") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareToString("1.0") == 0 ? 1 : 0) != 0);
    }

    @Test
    public void categoricalDaysSinceDate() {
        FieldValue period = FieldValueUtil.create((DataType)DataType.DATE_DAYS_SINCE_1960, (OpType)OpType.CATEGORICAL, (Object)"1960-01-03");
        Assert.assertEquals((Object)2, (Object)period.asInteger());
    }

    @Test
    public void categoricalSecondsSinceDate() {
        FieldValue period = FieldValueUtil.create((DataType)DataType.DATE_TIME_SECONDS_SINCE_1960, (OpType)OpType.CATEGORICAL, (Object)"1960-01-03T03:30:03");
        Assert.assertEquals((Object)185403, (Object)period.asInteger());
    }
}

