/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.Array;
import org.dmg.pmml.MatCell;
import org.dmg.pmml.Matrix;
import org.jpmml.evaluator.MatrixUtil;
import org.junit.Assert;
import org.junit.Test;

public class MatrixUtilTest {
    @Test
    public void diagonalMatrix() {
        Matrix matrix = new Matrix().withKind(Matrix.Kind.DIAGONAL).withArrays(new Array[]{new Array(Array.Type.INT, "1 2 3")});
        Assert.assertEquals((Object)1, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)1));
        Assert.assertEquals((Object)2, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)2, (int)2));
        Assert.assertEquals((Object)3, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)3));
        Assert.assertEquals(null, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)3));
        Assert.assertEquals(null, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)1));
        matrix = matrix.withOffDiagDefault(Double.valueOf(0.0));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)3));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)1));
        Assert.assertEquals((long)3L, (long)MatrixUtil.getRows((Matrix)matrix));
        Assert.assertEquals((long)3L, (long)MatrixUtil.getColumns((Matrix)matrix));
        try {
            MatrixUtil.getElementAt((Matrix)matrix, (int)0, (int)0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        try {
            MatrixUtil.getElementAt((Matrix)matrix, (int)4, (int)4);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void symmetricMatrix() {
        Matrix matrix = new Matrix().withKind(Matrix.Kind.SYMMETRIC).withArrays(new Array[]{new Array(Array.Type.INT, "1"), new Array(Array.Type.INT, "4 2"), new Array(Array.Type.INT, "6 5 3")});
        Assert.assertEquals((Object)1, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)1));
        Assert.assertEquals((Object)2, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)2, (int)2));
        Assert.assertEquals((Object)3, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)3));
        Assert.assertEquals((Object)4, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)2));
        Assert.assertEquals((Object)4, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)2, (int)1));
        Assert.assertEquals((Object)5, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)2, (int)3));
        Assert.assertEquals((Object)5, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)2));
        Assert.assertEquals((Object)6, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)3));
        Assert.assertEquals((Object)6, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)3));
        Assert.assertEquals((long)3L, (long)MatrixUtil.getRows((Matrix)matrix));
        Assert.assertEquals((long)3L, (long)MatrixUtil.getColumns((Matrix)matrix));
        try {
            MatrixUtil.getElementAt((Matrix)matrix, (int)0, (int)0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        try {
            MatrixUtil.getElementAt((Matrix)matrix, (int)4, (int)4);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void anyMatrixDense() {
        Matrix matrix = new Matrix().withArrays(new Array[]{new Array(Array.Type.REAL, "0 0 0 42 0"), new Array(Array.Type.REAL, "0 1 0 0 0"), new Array(Array.Type.REAL, "5 0 0 0 0"), new Array(Array.Type.REAL, "0 0 0 0 7"), new Array(Array.Type.REAL, "0 0 9 0 0")});
        MatrixUtilTest.anyMatrix(matrix);
    }

    @Test
    public void anyMatrixSparse() {
        Matrix matrix = new Matrix().withDiagDefault(Double.valueOf(0.0)).withOffDiagDefault(Double.valueOf(0.0)).withMatCells(new MatCell[]{new MatCell(Integer.valueOf(1), Integer.valueOf(4), "42"), new MatCell(Integer.valueOf(2), Integer.valueOf(2), "1"), new MatCell(Integer.valueOf(3), Integer.valueOf(1), "5"), new MatCell(Integer.valueOf(4), Integer.valueOf(5), "7"), new MatCell(Integer.valueOf(5), Integer.valueOf(3), "9")});
        MatrixUtilTest.anyMatrix(matrix);
    }

    private static void anyMatrix(Matrix matrix) {
        Assert.assertEquals((Object)42.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)4));
        Assert.assertEquals((Object)1.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)2, (int)2));
        Assert.assertEquals((Object)5.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)1));
        Assert.assertEquals((Object)7.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)4, (int)5));
        Assert.assertEquals((Object)9.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)5, (int)3));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)1));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)5));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)5, (int)1));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)5, (int)5));
        Assert.assertEquals((long)5L, (long)MatrixUtil.getRows((Matrix)matrix));
        Assert.assertEquals((long)5L, (long)MatrixUtil.getColumns((Matrix)matrix));
        try {
            MatrixUtil.getElementAt((Matrix)matrix, (int)0, (int)0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

