/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MissingValueStrategyType;
import org.dmg.pmml.TreeModel;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.jpmml.evaluator.NodeClassificationMap;
import org.jpmml.evaluator.TreeModelEvaluator;
import org.junit.Assert;
import org.junit.Test;

public class MissingValueStrategyTest
extends ModelEvaluatorTest {
    @Test
    public void nullPrediction() throws Exception {
        Map<FieldName, ?> arguments = MissingValueStrategyTest.createArguments("outlook", "sunny", "temperature", null, "humidity", null);
        NodeClassificationMap targetValue = this.evaluate(MissingValueStrategyType.NULL_PREDICTION, arguments);
        Assert.assertNull((Object)targetValue);
    }

    @Test
    public void nullPredictionDefault() throws Exception {
        NodeClassificationMap targetValue = this.evaluate(MissingValueStrategyType.NULL_PREDICTION, Collections.emptyMap());
        Assert.assertNull((Object)targetValue);
    }

    @Test
    public void lastPrediction() throws Exception {
        Map<FieldName, ?> arguments = MissingValueStrategyTest.createArguments("outlook", "sunny", "temperature", null, "humidity", null);
        NodeClassificationMap targetValue = this.evaluate(MissingValueStrategyType.LAST_PREDICTION, arguments);
        Assert.assertEquals((Object)"2", (Object)targetValue.getEntityId());
        Assert.assertEquals((Object)0.8, (Object)targetValue.getProbability("will play"));
        Assert.assertEquals((Object)0.04, (Object)targetValue.getProbability("may play"));
        Assert.assertEquals((Object)0.16, (Object)targetValue.getProbability("no play"));
    }

    @Test
    public void lastPredictionDefault() throws Exception {
        NodeClassificationMap targetValue = this.evaluate(MissingValueStrategyType.LAST_PREDICTION, Collections.emptyMap());
        Assert.assertEquals((Object)"1", (Object)targetValue.getEntityId());
        Assert.assertEquals((Object)0.6, (Object)targetValue.getProbability("will play"));
        Assert.assertEquals((Object)0.3, (Object)targetValue.getProbability("may play"));
        Assert.assertEquals((Object)0.1, (Object)targetValue.getProbability("no play"));
    }

    @Test
    public void defaultChildSinglePenalty() throws Exception {
        Map<FieldName, ?> arguments = MissingValueStrategyTest.createArguments("outlook", null, "temperature", 40.0, "humidity", 70.0);
        NodeClassificationMap targetValue = this.evaluate(MissingValueStrategyType.DEFAULT_CHILD, 0.8, arguments);
        Assert.assertEquals((Object)"4", (Object)targetValue.getEntityId());
        Assert.assertEquals((Object)0.4, (Object)targetValue.getProbability("will play"));
        Assert.assertEquals((Object)0.0, (Object)targetValue.getProbability("may play"));
        Assert.assertEquals((Object)0.6, (Object)targetValue.getProbability("no play"));
        double missingValuePenatly = 0.8;
        Assert.assertEquals((Object)(0.4 * missingValuePenatly), (Object)targetValue.getConfidence("will play"));
        Assert.assertEquals((Object)(0.0 * missingValuePenatly), (Object)targetValue.getConfidence("may play"));
        Assert.assertEquals((Object)(0.6 * missingValuePenatly), (Object)targetValue.getConfidence("no play"));
    }

    @Test
    public void defaultChildMultiplePenalties() throws Exception {
        Map<FieldName, ?> arguments = MissingValueStrategyTest.createArguments("outlook", null, "temperature", null, "humidity", 70.0);
        NodeClassificationMap targetValue = this.evaluate(MissingValueStrategyType.DEFAULT_CHILD, 0.8, arguments);
        Assert.assertEquals((Object)"3", (Object)targetValue.getEntityId());
        Assert.assertEquals((Object)0.9, (Object)targetValue.getProbability("will play"));
        Assert.assertEquals((Object)0.05, (Object)targetValue.getProbability("may play"));
        Assert.assertEquals((Object)0.05, (Object)targetValue.getProbability("no play"));
        double missingValuePenalty = 0.6400000000000001;
        Assert.assertEquals((Object)(0.9 * missingValuePenalty), (Object)targetValue.getConfidence("will play"));
        Assert.assertEquals((Object)(0.05 * missingValuePenalty), (Object)targetValue.getConfidence("may play"));
        Assert.assertEquals((Object)(0.05 * missingValuePenalty), (Object)targetValue.getConfidence("no play"));
    }

    private NodeClassificationMap evaluate(MissingValueStrategyType missingValueStrategy, Map<FieldName, ?> arguments) throws Exception {
        return this.evaluate(missingValueStrategy, null, arguments);
    }

    private NodeClassificationMap evaluate(MissingValueStrategyType missingValueStrategy, Double missingValuePenalty, Map<FieldName, ?> arguments) throws Exception {
        TreeModelEvaluator evaluator = (TreeModelEvaluator)this.createModelEvaluator();
        TreeModel treeModel = ((TreeModel)evaluator.getModel()).withMissingValueStrategy(missingValueStrategy).withMissingValuePenalty(missingValuePenalty);
        Map result = evaluator.evaluate(arguments);
        return (NodeClassificationMap)result.get(evaluator.getTargetField());
    }
}

