/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Map;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.jpmml.evaluator.NaiveBayesModelEvaluator;
import org.junit.Assert;
import org.junit.Test;

public class TargetValueCountsTest
extends ModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        NaiveBayesModelEvaluator evaluator = (NaiveBayesModelEvaluator)this.createModelEvaluator();
        Map<FieldName, ?> arguments = TargetValueCountsTest.createArguments("age of individual", 24, "gender", "male", "no of claims", "2", "domicile", null, "age of car", 1.0);
        Map fieldCountSums = evaluator.getFieldCountSums();
        Map countSums = (Map)fieldCountSums.get(new FieldName("gender"));
        Assert.assertEquals((Object)8598.0, countSums.get("100"));
        Assert.assertEquals((Object)2533.0, countSums.get("500"));
        Assert.assertEquals((Object)1522.0, countSums.get("1000"));
        Assert.assertEquals((Object)697.0, countSums.get("5000"));
        Assert.assertEquals((Object)90.0, countSums.get("10000"));
        Map result = evaluator.evaluate(arguments);
        ClassificationMap targetValue = (ClassificationMap)result.get(evaluator.getTargetField());
        double l0 = 0.01180900682158175;
        double l1 = 2557.0 * TargetValueCountsTest.probability(24.936, 0.516, 24.0) * 1321.0 / 2533.0 * 10.0 / 2436.0 * 182.0 / 2266.0;
        double l2 = 1530.0 * TargetValueCountsTest.probability(24.588, 0.635, 24.0) * 780.0 / 1522.0 * 9.0 / 1496.0 * 51.0 / 1191.0;
        double l3 = 709.0 * TargetValueCountsTest.probability(24.428, 0.379, 24.0) * 405.0 / 697.0 * 0.001 * 26.0 / 699.0;
        double l4 = 100.0 * TargetValueCountsTest.probability(24.77, 0.314, 24.0) * 42.0 / 90.0 * 10.0 / 98.0 * 6.0 / 87.0;
        double denominator = l0 + l1 + l2 + l3 + l4;
        Assert.assertEquals((double)(l0 / denominator), (double)((Double)targetValue.get((Object)"100")), (double)1.0E-8);
        Assert.assertEquals((double)(l1 / denominator), (double)((Double)targetValue.get((Object)"500")), (double)1.0E-8);
        Assert.assertEquals((double)(l2 / denominator), (double)((Double)targetValue.get((Object)"1000")), (double)1.0E-8);
        Assert.assertEquals((double)(l3 / denominator), (double)((Double)targetValue.get((Object)"5000")), (double)1.0E-8);
        Assert.assertEquals((double)(l4 / denominator), (double)((Double)targetValue.get((Object)"10000")), (double)1.0E-8);
    }

    private static double probability(double mean, double variance, double x) {
        NormalDistribution distribution = new NormalDistribution(mean, Math.sqrt(variance));
        return distribution.density(x);
    }
}

