/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.TypeUtil;

@Beta
public class ClassificationMap<K>
extends LinkedHashMap<K, Double>
implements Computable {
    private Type type = null;
    private Object result = null;
    private static final Ordering<Double> BIGGER_IS_BETTER = Ordering.natural();
    private static final Ordering<Double> SMALLER_IS_BETTER = Ordering.natural().reverse();

    protected ClassificationMap(Type type) {
        this.setType(type);
    }

    @Override
    public Object getResult() {
        if (this.result == null) {
            throw new EvaluationException();
        }
        return this.result;
    }

    void computeResult(DataType dataType) {
        Map.Entry<K, Double> entry = this.getWinner();
        if (entry == null) {
            throw new EvaluationException();
        }
        Object result = TypeUtil.parseOrCast(dataType, entry.getKey());
        this.setResult(result);
    }

    void setResult(Object result) {
        this.result = result;
    }

    Double getFeature(String value) {
        Double result = (Double)this.get(value);
        if (result == null) {
            Type type = this.getType();
            return type.getDefault();
        }
        return result;
    }

    Map.Entry<K, Double> getWinner() {
        Ordering<Map.Entry<K, Double>> ordering = this.createOrdering();
        try {
            return (Map.Entry)ordering.max(this.entrySet());
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    List<Map.Entry<K, Double>> getWinnerList() {
        Ordering ordering = this.createOrdering().reverse();
        return ordering.sortedCopy(this.entrySet());
    }

    List<K> getWinnerKeys() {
        List<Map.Entry<K, Double>> winners = this.getWinnerList();
        Function function = new Function<Map.Entry<K, Double>, K>(){

            public K apply(Map.Entry<K, Double> entry) {
                return entry.getKey();
            }
        };
        return Lists.transform(winners, (Function)function);
    }

    List<Double> getWinnerValues() {
        List<Map.Entry<K, Double>> winners = this.getWinnerList();
        Function function = new Function<Map.Entry<K, Double>, Double>(){

            public Double apply(Map.Entry<K, Double> entry) {
                return entry.getValue();
            }
        };
        return Lists.transform(winners, (Function)function);
    }

    void normalizeValues() {
        ClassificationMap.normalize(this);
    }

    Ordering<Map.Entry<K, Double>> createOrdering() {
        Comparator comparator = new Comparator<Map.Entry<K, Double>>(){
            private Type type;
            {
                this.type = ClassificationMap.this.getType();
            }

            @Override
            public int compare(Map.Entry<K, Double> left, Map.Entry<K, Double> right) {
                return this.type.compare(left.getValue(), right.getValue());
            }
        };
        return Ordering.from((Comparator)comparator);
    }

    @Override
    public String toString() {
        Objects.ToStringHelper helper = this.toStringHelper();
        return helper.toString();
    }

    protected Objects.ToStringHelper toStringHelper() {
        Type type = this.getType();
        Objects.ToStringHelper helper = Objects.toStringHelper((Object)this).add("type", (Object)type).add(type.entryKey(), this.entrySet());
        return helper;
    }

    public Type getType() {
        return this.type;
    }

    private void setType(Type type) {
        this.type = type;
    }

    public static <K> Double sum(Map<K, Double> map) {
        return ClassificationMap.sum(map, null);
    }

    private static <K> Double sum(Map<K, Double> map, Function<Double, Double> function) {
        double sum = 0.0;
        Collection<Double> values = map.values();
        for (Double value : values) {
            if (function != null) {
                value = (Double)function.apply((Object)value);
            }
            sum += value.doubleValue();
        }
        return sum;
    }

    public static <K> void normalize(Map<K, Double> map) {
        ClassificationMap.normalize(map, null);
    }

    public static <K> void normalizeSoftMax(Map<K, Double> map) {
        Function<Double, Double> function = new Function<Double, Double>(){

            public Double apply(Double value) {
                return Math.exp(value);
            }
        };
        ClassificationMap.normalize(map, function);
    }

    private static <K> void normalize(Map<K, Double> map, Function<Double, Double> function) {
        double sum = ClassificationMap.sum(map, function);
        Set<Map.Entry<K, Double>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            Double value = (Double)entry.getValue();
            if (function != null) {
                value = (Double)function.apply((Object)value);
            }
            entry.setValue(value / sum);
        }
    }

    static /* synthetic */ Ordering access$000() {
        return BIGGER_IS_BETTER;
    }

    static /* synthetic */ Ordering access$100() {
        return SMALLER_IS_BETTER;
    }

    public static enum Type implements Comparator<Double>
    {
        PROBABILITY((Ordering<Double>)ClassificationMap.access$000(), (Range<Double>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))),
        CONFIDENCE((Ordering<Double>)ClassificationMap.access$000(), (Range<Double>)Range.atLeast((Comparable)Double.valueOf(0.0))),
        DISTANCE(ClassificationMap.access$100(), Range.atLeast((Comparable)Double.valueOf(0.0))){

            @Override
            public double getDefault() {
                return Double.POSITIVE_INFINITY;
            }
        }
        ,
        SIMILARITY((Ordering<Double>)ClassificationMap.access$000(), (Range<Double>)Range.atLeast((Comparable)Double.valueOf(0.0))),
        VOTE((Ordering<Double>)ClassificationMap.access$000(), (Range<Double>)Range.atLeast((Comparable)Double.valueOf(0.0)));

        private Ordering<Double> ordering;
        private Range<Double> range;

        private Type(Ordering<Double> ordering, Range<Double> range) {
            this.setOrdering(ordering);
            this.setRange(range);
        }

        @Override
        public int compare(Double left, Double right) {
            if (left == null || right == null) {
                throw new EvaluationException();
            }
            Ordering<Double> ordering = this.getOrdering();
            return ordering.compare((Object)left, (Object)right);
        }

        public double getDefault() {
            return 0.0;
        }

        public boolean isValid(Double value) {
            Range<Double> range = this.getRange();
            return range.contains((Comparable)value);
        }

        protected String entryKey() {
            String name = this.name();
            return name.toLowerCase() + "_entries";
        }

        public Ordering<Double> getOrdering() {
            return this.ordering;
        }

        private void setOrdering(Ordering<Double> ordering) {
            this.ordering = ordering;
        }

        public Range<Double> getRange() {
            return this.range;
        }

        private void setRange(Range<Double> range) {
            this.range = range;
        }
    }
}

