/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.dmg.pmml.Cluster;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EntityClassificationMap;
import org.jpmml.evaluator.HasAffinity;
import org.jpmml.evaluator.HasDisplayValue;
import org.jpmml.evaluator.HasEntityAffinity;

@Beta
public class ClusterClassificationMap
extends EntityClassificationMap<Cluster>
implements HasDisplayValue,
HasAffinity,
HasEntityAffinity {
    protected ClusterClassificationMap(ClassificationMap.Type type) {
        super(type);
        ClusterClassificationMap.checkType(type);
    }

    protected ClusterClassificationMap(ClassificationMap.Type type, Cluster cluster) {
        super(type, cluster);
        ClusterClassificationMap.checkType(type);
    }

    @Override
    public Set<String> getCategoryValues() {
        return this.keySet();
    }

    @Override
    public String getDisplayValue() {
        Cluster cluster = (Cluster)this.getEntity();
        return cluster.getName();
    }

    @Override
    public Double getAffinity(String value) {
        return this.getFeature(value);
    }

    @Override
    public Double getEntityAffinity() {
        return this.getAffinity(this.getEntityId());
    }

    private static void checkType(ClassificationMap.Type type) {
        Preconditions.checkArgument((ClassificationMap.Type.DISTANCE.equals(type) || ClassificationMap.Type.SIMILARITY.equals(type) ? 1 : 0) != 0);
    }
}

