/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import org.dmg.pmml.Entity;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.HasEntityId;

@Beta
public abstract class EntityClassificationMap<E extends Entity>
extends ClassificationMap<String>
implements HasEntityId {
    private E entity = null;
    private Double entityValue = null;

    protected EntityClassificationMap(ClassificationMap.Type type) {
        super(type);
    }

    protected EntityClassificationMap(ClassificationMap.Type type, E entity) {
        super(type);
        this.setEntity(entity);
    }

    @Override
    public String getEntityId() {
        E entity = this.getEntity();
        if (entity != null) {
            return entity.getId();
        }
        return null;
    }

    Double put(E entity, String key, Double value) {
        ClassificationMap.Type type = this.getType();
        if (this.entityValue == null || type.compare(value, this.entityValue) > 0) {
            this.entityValue = value;
            this.setEntity(entity);
        }
        return super.put(key, value);
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        Objects.ToStringHelper helper = super.toStringHelper().add("entityId", (Object)this.getEntityId());
        return helper;
    }

    public E getEntity() {
        return this.entity;
    }

    void setEntity(E entity) {
        this.entity = entity;
    }
}

