/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;

public abstract class FieldValue
implements Serializable {
    private DataType dataType = null;
    private Object value = null;

    public FieldValue(DataType dataType, Object value) {
        this.setDataType(dataType);
        this.setValue(value);
    }

    public abstract OpType getOpType();

    public boolean equalsString(String string) {
        return TypeUtil.equals(this.getDataType(), this.getValue(), this.parseValue(string));
    }

    public boolean equalsAnyString(Iterable<String> strings) {
        for (String string : strings) {
            boolean equals = this.equalsString(string);
            if (!equals) continue;
            return true;
        }
        return false;
    }

    public boolean equalsValue(FieldValue value) {
        DataType dataType = TypeUtil.getResultDataType(this.getDataType(), value.getDataType());
        return TypeUtil.equals(dataType, this.getValue(), value.getValue());
    }

    public boolean equalsAnyValue(Iterable<FieldValue> values) {
        for (FieldValue value : values) {
            boolean equals = this.equalsValue(value);
            if (!equals) continue;
            return true;
        }
        return false;
    }

    public int compareToString(String string) {
        return TypeUtil.compare(this.getDataType(), this.getValue(), this.parseValue(string));
    }

    public int compareToValue(FieldValue value) {
        DataType dataType = TypeUtil.getResultDataType(this.getDataType(), value.getDataType());
        return TypeUtil.compare(dataType, this.getValue(), value.getValue());
    }

    protected Object parseValue(String string) {
        DataType dataType = this.getDataType();
        return TypeUtil.parse(dataType, string);
    }

    public String asString() {
        return (String)this.getValue(DataType.STRING);
    }

    public Integer asInteger() {
        return (Integer)this.getValue(DataType.INTEGER);
    }

    public Number asNumber() {
        Object value = this.getValue();
        if (value instanceof Number) {
            return (Number)value;
        }
        return (Double)this.getValue(DataType.DOUBLE);
    }

    public Boolean asBoolean() {
        return (Boolean)this.getValue(DataType.BOOLEAN);
    }

    public LocalDateTime asLocalDateTime() {
        return (LocalDateTime)this.getValue(DataType.DATE_TIME);
    }

    public LocalDate asLocalDate() {
        return (LocalDate)this.getValue(DataType.DATE);
    }

    public LocalTime asLocalTime() {
        return (LocalTime)this.getValue(DataType.TIME);
    }

    public DateTime asDateTime() {
        try {
            LocalDateTime dateTime = this.asLocalDateTime();
            return dateTime.toDateTime();
        }
        catch (TypeCheckException tceDateTime) {
            try {
                LocalDate date = this.asLocalDate();
                return date.toDateTimeAtStartOfDay();
            }
            catch (TypeCheckException tceDate) {
                try {
                    LocalTime time = this.asLocalTime();
                    return time.toDateTimeToday();
                }
                catch (TypeCheckException typeCheckException) {
                    throw tceDateTime;
                }
            }
        }
    }

    private Object getValue(DataType dataType) {
        Object value = this.getValue();
        try {
            return TypeUtil.cast(dataType, value);
        }
        catch (TypeCheckException tce) {
            try {
                if (value instanceof String) {
                    String string = (String)value;
                    return TypeUtil.parse(dataType, string);
                }
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            throw tce;
        }
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper((Object)this).add("opType", (Object)this.getOpType()).add("dataType", (Object)this.getDataType()).add("value", this.getValue());
        return helper.toString();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException();
        }
        this.dataType = dataType;
    }

    public Object getValue() {
        return this.value;
    }

    private void setValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }
}

