/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Row;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.FieldValue;
import org.w3c.dom.Element;

public class InlineTableUtil {
    private static final LoadingCache<InlineTable, Table<Integer, String, String>> contentCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<InlineTable, Table<Integer, String, String>>(){

        public Table<Integer, String, String> load(InlineTable inlineTable) {
            return Tables.unmodifiableTable(InlineTableUtil.parse(inlineTable));
        }
    });

    private InlineTableUtil() {
    }

    public static Table<Integer, String, String> getContent(InlineTable inlineTable) {
        return CacheUtil.getValue(inlineTable, contentCache);
    }

    public static Table<Integer, String, String> parse(InlineTable inlineTable) {
        HashBasedTable result = HashBasedTable.create();
        Integer rowKey = 1;
        List rows = inlineTable.getRows();
        for (Row row : rows) {
            List cells = row.getContent();
            for (Object cell : cells) {
                if (!(cell instanceof Element)) continue;
                Element element = (Element)cell;
                result.put((Object)rowKey, (Object)element.getTagName(), (Object)element.getTextContent());
            }
            rowKey = rowKey + 1;
        }
        return result;
    }

    public static Map<String, String> match(Table<Integer, String, String> table, Map<String, FieldValue> values) {
        Set rowKeys = table.rowKeySet();
        block0: for (Integer rowKey : rowKeys) {
            Map row = table.row((Object)rowKey);
            if (values.size() < row.size() - 1) continue;
            Set<Map.Entry<String, FieldValue>> entries = values.entrySet();
            for (Map.Entry entry : entries) {
                boolean equals;
                String key = (String)entry.getKey();
                FieldValue value = (FieldValue)entry.getValue();
                String rowValue = (String)row.get(key);
                if (rowValue != null && (equals = value.equalsString(rowValue))) continue;
                continue block0;
            }
            return row;
        }
        return null;
    }
}

