/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.ActivationFunctionType;
import org.dmg.pmml.Connection;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.NeuralInput;
import org.dmg.pmml.NeuralInputs;
import org.dmg.pmml.NeuralLayer;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.NeuralOutput;
import org.dmg.pmml.NeuralOutputs;
import org.dmg.pmml.Neuron;
import org.dmg.pmml.NnNormalizationMethodType;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.NeuronClassificationMap;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class NeuralNetworkEvaluator
extends ModelEvaluator<NeuralNetwork>
implements HasEntityRegistry<Entity> {
    private static final LoadingCache<NeuralNetwork, BiMap<String, Entity>> entityCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<NeuralNetwork, BiMap<String, Entity>>(){

        public BiMap<String, Entity> load(NeuralNetwork neuralNetwork) {
            ImmutableBiMap.Builder<String, NeuralInput> builder = new ImmutableBiMap.Builder<String, NeuralInput>();
            NeuralInputs neuralInputs = neuralNetwork.getNeuralInputs();
            if (neuralInputs == null) {
                throw new InvalidFeatureException((PMMLObject)neuralNetwork);
            }
            for (NeuralInput neuralInput : neuralInputs) {
                builder = EntityUtil.put(neuralInput, builder);
            }
            List neuralLayers = neuralNetwork.getNeuralLayers();
            for (NeuralLayer neuralLayer : neuralLayers) {
                List neurons = neuralLayer.getNeurons();
                for (Neuron neuron : neurons) {
                    builder = EntityUtil.put(neuron, builder);
                }
            }
            return builder.build();
        }
    });

    public NeuralNetworkEvaluator(PMML pmml) {
        this(pmml, (NeuralNetwork)NeuralNetworkEvaluator.find((List)pmml.getModels(), NeuralNetwork.class));
    }

    public NeuralNetworkEvaluator(PMML pmml, NeuralNetwork neuralNetwork) {
        super(pmml, neuralNetwork);
    }

    public String getSummary() {
        return "Neural network";
    }

    @Override
    public BiMap<String, Entity> getEntityRegistry() {
        return this.getValue(entityCache);
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, Object> predictions;
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        if (!neuralNetwork.isScorable()) {
            throw new InvalidResultException((PMMLObject)neuralNetwork);
        }
        MiningFunctionType miningFunction = neuralNetwork.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)neuralNetwork, (Enum)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluateRegression(ModelEvaluationContext context) {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        Map<String, Double> entityOutputs = this.evaluateRaw(context);
        if (entityOutputs == null) {
            return TargetUtil.evaluateRegressionDefault(context);
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        NeuralOutputs neuralOutputs = neuralNetwork.getNeuralOutputs();
        if (neuralOutputs == null) {
            throw new InvalidFeatureException((PMMLObject)neuralNetwork);
        }
        for (NeuralOutput neuralOutput : neuralOutputs) {
            Double value;
            FieldName field;
            String id = neuralOutput.getOutputNeuron();
            Expression expression = this.getExpression(neuralOutput.getDerivedField(), context);
            if (expression instanceof FieldRef) {
                FieldRef fieldRef = (FieldRef)expression;
                field = fieldRef.getField();
                value = entityOutputs.get(id);
                result.put(field, value);
                continue;
            }
            if (expression instanceof NormContinuous) {
                NormContinuous normContinuous = (NormContinuous)expression;
                field = normContinuous.getField();
                value = NormalizationUtil.denormalize(normContinuous, entityOutputs.get(id));
                result.put(field, value);
                continue;
            }
            throw new UnsupportedFeatureException((PMMLObject)expression);
        }
        return TargetUtil.evaluateRegression(result, context);
    }

    private Map<FieldName, ? extends ClassificationMap<?>> evaluateClassification(ModelEvaluationContext context) {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        BiMap<String, Entity> entities = this.getEntityRegistry();
        Map<String, Double> entityOutputs = this.evaluateRaw(context);
        if (entityOutputs == null) {
            return TargetUtil.evaluateClassificationDefault(context);
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        NeuralOutputs neuralOutputs = neuralNetwork.getNeuralOutputs();
        if (neuralOutputs == null) {
            throw new InvalidFeatureException((PMMLObject)neuralNetwork);
        }
        for (NeuralOutput neuralOutput : neuralOutputs) {
            String id = neuralOutput.getOutputNeuron();
            Expression expression = this.getExpression(neuralOutput.getDerivedField(), context);
            if (expression instanceof NormDiscrete) {
                NormDiscrete normDiscrete = (NormDiscrete)expression;
                FieldName field = normDiscrete.getField();
                NeuronClassificationMap values = (NeuronClassificationMap)result.get(field);
                if (values == null) {
                    values = new NeuronClassificationMap();
                    result.put(field, values);
                }
                Entity entity = (Entity)entities.get(id);
                Double value = entityOutputs.get(id);
                values.put(entity, normDiscrete.getValue(), value);
                continue;
            }
            throw new UnsupportedFeatureException((PMMLObject)expression);
        }
        return TargetUtil.evaluateClassification(result, context);
    }

    private Expression getExpression(DerivedField derivedField, EvaluationContext context) {
        Expression expression = derivedField.getExpression();
        if (expression instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)expression;
            EvaluationContext.Result<DerivedField> result = context.resolveDerivedField(fieldRef.getField());
            if (result != null) {
                return this.getExpression(result.getElement(), context);
            }
            return fieldRef;
        }
        return expression;
    }

    public Map<String, Double> evaluateRaw(EvaluationContext context) {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        LinkedHashMap result = Maps.newLinkedHashMap();
        NeuralInputs neuralInputs = neuralNetwork.getNeuralInputs();
        if (neuralInputs == null) {
            throw new InvalidFeatureException((PMMLObject)neuralNetwork);
        }
        for (NeuralInput neuralInput : neuralInputs) {
            DerivedField derivedField = neuralInput.getDerivedField();
            FieldValue value = ExpressionUtil.evaluate(derivedField, context);
            if (value == null) {
                return null;
            }
            result.put(neuralInput.getId(), value.asNumber().doubleValue());
        }
        List neuralLayers = neuralNetwork.getNeuralLayers();
        for (NeuralLayer neuralLayer : neuralLayers) {
            LinkedHashMap outputs = Maps.newLinkedHashMap();
            List neurons = neuralLayer.getNeurons();
            for (Neuron neuron : neurons) {
                double z = neuron.getBias();
                List connections = neuron.getConnections();
                for (Connection connection : connections) {
                    double input = (Double)result.get(connection.getFrom());
                    z += input * connection.getWeight();
                }
                double output = this.activation(z, neuralLayer);
                outputs.put(neuron.getId(), output);
            }
            this.normalizeNeuronOutputs(neuralLayer, outputs);
            result.putAll(outputs);
        }
        return result;
    }

    private void normalizeNeuronOutputs(NeuralLayer neuralLayer, Map<String, Double> values) {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        NeuralLayer locatable = neuralLayer;
        NnNormalizationMethodType normalizationMethod = neuralLayer.getNormalizationMethod();
        if (normalizationMethod == null) {
            locatable = neuralNetwork;
            normalizationMethod = neuralNetwork.getNormalizationMethod();
        }
        switch (normalizationMethod) {
            case NONE: {
                break;
            }
            case SIMPLEMAX: {
                ClassificationMap.normalize(values);
                break;
            }
            case SOFTMAX: {
                ClassificationMap.normalizeSoftMax(values);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)locatable, (Enum)normalizationMethod);
            }
        }
    }

    private double activation(double z, NeuralLayer neuralLayer) {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        NeuralLayer locatable = neuralLayer;
        ActivationFunctionType activationFunction = neuralLayer.getActivationFunction();
        if (activationFunction == null) {
            locatable = neuralNetwork;
            activationFunction = neuralNetwork.getActivationFunction();
        }
        if (activationFunction == null) {
            throw new InvalidFeatureException((PMMLObject)locatable);
        }
        switch (activationFunction) {
            case THRESHOLD: {
                Double threshold = neuralLayer.getThreshold();
                if (threshold == null) {
                    threshold = neuralNetwork.getThreshold();
                }
                return z > threshold ? 1.0 : 0.0;
            }
            case LOGISTIC: {
                return 1.0 / (1.0 + Math.exp(-z));
            }
            case TANH: {
                return Math.tanh(z);
            }
            case IDENTITY: {
                return z;
            }
            case EXPONENTIAL: {
                return Math.exp(z);
            }
            case RECIPROCAL: {
                return 1.0 / z;
            }
            case SQUARE: {
                return z * z;
            }
            case GAUSS: {
                return Math.exp(-(z * z));
            }
            case SINE: {
                return Math.sin(z);
            }
            case COSINE: {
                return Math.cos(z);
            }
            case ELLIOTT: {
                return z / (1.0 + Math.abs(z));
            }
            case ARCTAN: {
                return Math.atan(z);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)locatable, (Enum)activationFunction);
    }
}

