/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Node;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EntityClassificationMap;
import org.jpmml.evaluator.HasConfidence;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.TypeUtil;

@Beta
public class NodeClassificationMap
extends EntityClassificationMap<Node>
implements HasConfidence,
HasProbability {
    private Map<String, Double> confidences = Maps.newLinkedHashMap();

    protected NodeClassificationMap() {
        super(ClassificationMap.Type.PROBABILITY);
    }

    protected NodeClassificationMap(Node node) {
        super(ClassificationMap.Type.PROBABILITY, node);
    }

    @Override
    void computeResult(DataType dataType) {
        Node node = (Node)this.getEntity();
        String score = node.getScore();
        if (score != null) {
            Object result = TypeUtil.parseOrCast(dataType, score);
            super.setResult(result);
            return;
        }
        super.computeResult(dataType);
    }

    @Override
    public Set<String> getCategoryValues() {
        if (this.isEmpty()) {
            Node node = (Node)this.getEntity();
            return Collections.singleton(node.getScore());
        }
        return this.keySet();
    }

    @Override
    public Double getConfidence(String value) {
        return this.confidences.get(value);
    }

    void putConfidence(String value, Double confidence) {
        this.confidences.put(value, confidence);
    }

    @Override
    public Double getProbability(String value) {
        if (this.isEmpty()) {
            Node node = (Node)this.getEntity();
            if (value != null && value.equals(node.getScore())) {
                return 1.0;
            }
        }
        return this.getFeature(value);
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        Objects.ToStringHelper helper = super.toStringHelper().add(ClassificationMap.Type.CONFIDENCE.entryKey(), this.confidences.entrySet());
        return helper;
    }
}

