/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.Attribute;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.CompoundRule;
import org.dmg.pmml.False;
import org.dmg.pmml.Node;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Segment;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleRule;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.model.visitors.AbstractVisitor;

public class PredicateInterner
extends AbstractVisitor {
    private ElementHashMap<SimplePredicate> simplePredicateCache = new ElementHashMap<SimplePredicate>(){

        @Override
        public ElementKey createKey(SimplePredicate simplePredicate) {
            Object[] content = new Object[]{simplePredicate.getField(), simplePredicate.getOperator(), simplePredicate.getValue()};
            return new ElementKey(content);
        }
    };
    private ElementHashMap<SimpleSetPredicate> simpleSetPredicateCache = new ElementHashMap<SimpleSetPredicate>(){

        @Override
        public ElementKey createKey(SimpleSetPredicate simpleSetPredicate) {
            Array array = simpleSetPredicate.getArray();
            Object[] content = new Object[]{simpleSetPredicate.getField(), simpleSetPredicate.getBooleanOperator(), ArrayUtil.getContent(array)};
            return new ElementKey(content);
        }
    };
    private ElementHashMap<True> truePredicateCache = new ElementHashMap<True>(){

        @Override
        public ElementKey createKey(True truePredicate) {
            return ElementKey.EMPTY;
        }
    };
    private ElementHashMap<False> falsePredicateCache = new ElementHashMap<False>(){

        @Override
        public ElementKey createKey(False falsePredicate) {
            return ElementKey.EMPTY;
        }
    };

    public void applyTo(Visitable visitable) {
        this.reset();
        super.applyTo(visitable);
    }

    public void reset() {
        this.simplePredicateCache.clear();
        this.simpleSetPredicateCache.clear();
        this.truePredicateCache.clear();
        this.falsePredicateCache.clear();
    }

    public VisitorAction visit(Attribute attribute) {
        attribute.setPredicate(this.intern(attribute.getPredicate()));
        return super.visit(attribute);
    }

    public VisitorAction visit(CompoundPredicate compoundPredicate) {
        this.intern(compoundPredicate.getPredicates());
        return super.visit(compoundPredicate);
    }

    public VisitorAction visit(CompoundRule compoundRule) {
        compoundRule.setPredicate(this.intern(compoundRule.getPredicate()));
        return super.visit(compoundRule);
    }

    public VisitorAction visit(Node node) {
        node.setPredicate(this.intern(node.getPredicate()));
        return super.visit(node);
    }

    public VisitorAction visit(Segment segment) {
        segment.setPredicate(this.intern(segment.getPredicate()));
        return super.visit(segment);
    }

    public VisitorAction visit(SimpleRule simpleRule) {
        simpleRule.setPredicate(this.intern(simpleRule.getPredicate()));
        return super.visit(simpleRule);
    }

    public Predicate intern(Predicate predicate) {
        if (predicate instanceof SimplePredicate) {
            return this.intern((SimplePredicate)predicate);
        }
        if (predicate instanceof SimpleSetPredicate) {
            return this.intern((SimpleSetPredicate)predicate);
        }
        if (predicate instanceof True) {
            return this.intern((True)predicate);
        }
        if (predicate instanceof False) {
            return this.intern((False)predicate);
        }
        return predicate;
    }

    private void intern(List<Predicate> predicates) {
        for (int i = 0; i < predicates.size(); ++i) {
            predicates.set(i, this.intern(predicates.get(i)));
        }
    }

    private SimplePredicate intern(SimplePredicate simplePredicate) {
        if (!simplePredicate.hasExtensions()) {
            return this.simplePredicateCache.intern(simplePredicate);
        }
        return simplePredicate;
    }

    private SimpleSetPredicate intern(SimpleSetPredicate simpleSetPredicate) {
        if (!simpleSetPredicate.hasExtensions()) {
            return this.simpleSetPredicateCache.intern(simpleSetPredicate);
        }
        return simpleSetPredicate;
    }

    private True intern(True truePredicate) {
        if (!truePredicate.hasExtensions()) {
            return this.truePredicateCache.intern(truePredicate);
        }
        return truePredicate;
    }

    private False intern(False falsePredicate) {
        if (!falsePredicate.hasExtensions()) {
            return this.falsePredicateCache.intern(falsePredicate);
        }
        return falsePredicate;
    }

    private static abstract class ElementHashMap<E extends PMMLObject>
    extends HashMap<ElementKey, E> {
        private ElementHashMap() {
        }

        public abstract ElementKey createKey(E var1);

        public E intern(E object) {
            ElementKey key = this.createKey(object);
            Object value = (PMMLObject)this.get(key);
            if (value == null) {
                value = object;
                this.put(key, value);
            }
            return (E)value;
        }
    }

    private static class ElementKey {
        private Object[] content = null;
        public static final ElementKey EMPTY = new ElementKey(new Object[0]);

        private ElementKey(Object[] content) {
            this.setContent(content);
        }

        public int hashCode() {
            Object[] content = this.getContent();
            return Arrays.hashCode(content);
        }

        public boolean equals(Object object) {
            if (object instanceof ElementKey) {
                ElementKey that = (ElementKey)object;
                return Arrays.equals(this.getContent(), that.getContent());
            }
            return false;
        }

        public Object[] getContent() {
            return this.content;
        }

        private void setContent(Object[] content) {
            this.content = content;
        }
    }
}

