/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Array;
import org.jpmml.evaluator.ArrayUtil;
import org.junit.Assert;
import org.junit.Test;

public class ArrayUtilTest {
    @Test
    public void parseIntArray() {
        Assert.assertEquals(Arrays.asList("1", "2", "3"), ArrayUtilTest.parseIntArray("1 2 3"));
    }

    @Test
    public void parseStringArray() {
        Assert.assertEquals(Arrays.asList("a", "b", "c"), ArrayUtilTest.parseStringArray("a b c"));
        Assert.assertEquals(Arrays.asList("a", "b", "c"), ArrayUtilTest.parseStringArray("\"a\" \"b\" \"c\""));
        Assert.assertEquals(Arrays.asList("a b c"), ArrayUtilTest.parseStringArray("\"a b c\""));
        Assert.assertEquals(Arrays.asList("\"a b c"), ArrayUtilTest.parseStringArray("\"a b c"));
        Assert.assertEquals(Arrays.asList("\\a", "\\b\\", "c\\"), ArrayUtilTest.parseStringArray("\\a \\b\\ c\\"));
        Assert.assertEquals(Arrays.asList("a \"b\" c"), ArrayUtilTest.parseStringArray("\"a \\\"b\\\" c\""));
        Assert.assertEquals(Arrays.asList("\"a b c\""), ArrayUtilTest.parseStringArray("\"\\\"a b c\\\"\""));
    }

    private static List<String> parseIntArray(String content) {
        return ArrayUtil.parse((Array)new Array(content, Array.Type.INT));
    }

    private static List<String> parseStringArray(String content) {
        return ArrayUtil.parse((Array)new Array(content, Array.Type.STRING));
    }
}

