/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.MatCell;
import org.dmg.pmml.Matrix;
import org.jpmml.evaluator.MatrixUtil;
import org.junit.Assert;
import org.junit.Test;

public class MatrixUtilTest {
    @Test
    public void diagonalMatrix() {
        Matrix matrix = new Matrix();
        matrix.setKind(Matrix.Kind.DIAGONAL);
        List arrays = matrix.getArrays();
        arrays.add(new Array("1 2 3", Array.Type.INT));
        Assert.assertEquals((Object)1, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)1));
        Assert.assertEquals((Object)2, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)2, (int)2));
        Assert.assertEquals((Object)3, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)3));
        Assert.assertEquals(null, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)3));
        Assert.assertEquals(null, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)1));
        matrix.setOffDiagDefault(Double.valueOf(0.0));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)3));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)1));
        Assert.assertEquals((long)3L, (long)MatrixUtil.getRows((Matrix)matrix));
        Assert.assertEquals((long)3L, (long)MatrixUtil.getColumns((Matrix)matrix));
        try {
            MatrixUtil.getElementAt((Matrix)matrix, (int)0, (int)0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        try {
            MatrixUtil.getElementAt((Matrix)matrix, (int)4, (int)4);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void symmetricMatrix() {
        Matrix matrix = new Matrix();
        matrix.setKind(Matrix.Kind.SYMMETRIC);
        List arrays = matrix.getArrays();
        arrays.add(new Array("1", Array.Type.INT));
        arrays.add(new Array("4 2", Array.Type.INT));
        arrays.add(new Array("6 5 3", Array.Type.INT));
        Assert.assertEquals((Object)1, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)1));
        Assert.assertEquals((Object)2, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)2, (int)2));
        Assert.assertEquals((Object)3, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)3));
        Assert.assertEquals((Object)4, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)2));
        Assert.assertEquals((Object)4, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)2, (int)1));
        Assert.assertEquals((Object)5, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)2, (int)3));
        Assert.assertEquals((Object)5, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)2));
        Assert.assertEquals((Object)6, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)3));
        Assert.assertEquals((Object)6, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)3));
        Assert.assertEquals((long)3L, (long)MatrixUtil.getRows((Matrix)matrix));
        Assert.assertEquals((long)3L, (long)MatrixUtil.getColumns((Matrix)matrix));
        try {
            MatrixUtil.getElementAt((Matrix)matrix, (int)0, (int)0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        try {
            MatrixUtil.getElementAt((Matrix)matrix, (int)4, (int)4);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void anyMatrixDense() {
        Matrix matrix = new Matrix();
        List arrays = matrix.getArrays();
        arrays.add(new Array("0 0 0 42 0", Array.Type.REAL));
        arrays.add(new Array("0 1 0 0 0", Array.Type.REAL));
        arrays.add(new Array("5 0 0 0 0", Array.Type.REAL));
        arrays.add(new Array("0 0 0 0 7", Array.Type.REAL));
        arrays.add(new Array("0 0 9 0 0", Array.Type.REAL));
        MatrixUtilTest.anyMatrix(matrix);
    }

    @Test
    public void anyMatrixSparse() {
        Matrix matrix = new Matrix();
        List matCells = matrix.getMatCells();
        matCells.add(new MatCell("42", 1, 4));
        matCells.add(new MatCell("1", 2, 2));
        matCells.add(new MatCell("5", 3, 1));
        matCells.add(new MatCell("7", 4, 5));
        matCells.add(new MatCell("9", 5, 3));
        matrix.setDiagDefault(Double.valueOf(0.0));
        matrix.setOffDiagDefault(Double.valueOf(0.0));
        MatrixUtilTest.anyMatrix(matrix);
    }

    private static void anyMatrix(Matrix matrix) {
        Assert.assertEquals((Object)42.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)4));
        Assert.assertEquals((Object)1.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)2, (int)2));
        Assert.assertEquals((Object)5.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)3, (int)1));
        Assert.assertEquals((Object)7.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)4, (int)5));
        Assert.assertEquals((Object)9.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)5, (int)3));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)1));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)1, (int)5));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)5, (int)1));
        Assert.assertEquals((Object)0.0, (Object)MatrixUtil.getElementAt((Matrix)matrix, (int)5, (int)5));
        Assert.assertEquals((long)5L, (long)MatrixUtil.getRows((Matrix)matrix));
        Assert.assertEquals((long)5L, (long)MatrixUtil.getColumns((Matrix)matrix));
        try {
            MatrixUtil.getElementAt((Matrix)matrix, (int)0, (int)0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

