/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.dmg.pmml.Cluster;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EntityClassificationMap;
import org.jpmml.evaluator.HasAffinity;
import org.jpmml.evaluator.HasClusterAffinity;
import org.jpmml.evaluator.HasClusterId;
import org.jpmml.evaluator.HasDisplayValue;

@Beta
public class ClusterClassificationMap
extends EntityClassificationMap<Cluster>
implements HasDisplayValue,
HasClusterId,
HasAffinity,
HasClusterAffinity {
    protected ClusterClassificationMap(ClassificationMap.Type type) {
        super(type);
        Preconditions.checkArgument((ClassificationMap.Type.DISTANCE.equals(type) || ClassificationMap.Type.SIMILARITY.equals(type) ? 1 : 0) != 0);
    }

    protected ClusterClassificationMap(ClassificationMap.Type type, Cluster cluster) {
        super(type, cluster);
        Preconditions.checkArgument((ClassificationMap.Type.DISTANCE.equals(type) || ClassificationMap.Type.SIMILARITY.equals(type) ? 1 : 0) != 0);
    }

    @Override
    public String getDisplayValue() {
        Cluster cluster = (Cluster)this.getEntity();
        return cluster.getName();
    }

    @Override
    public String getClusterId() {
        return this.getEntityId();
    }

    @Override
    public Double getAffinity(String value) {
        return this.getFeature(value);
    }

    @Override
    public Double getClusterAffinity() {
        return this.getAffinity(this.getClusterId());
    }
}

