/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

public class VerificationUtil {
    private VerificationUtil() {
    }

    public static boolean acceptable(Object expected, Object actual, double precision, double zeroThreshold) {
        if (expected == null) {
            return actual == null;
        }
        if (expected instanceof Number && actual instanceof Number) {
            return VerificationUtil.acceptable((Number)expected, (Number)actual, precision, zeroThreshold);
        }
        return expected.equals(actual);
    }

    static boolean acceptable(Number expected, Number actual) {
        return VerificationUtil.acceptable(expected, actual, 1.0E-7, 1.0E-7);
    }

    public static boolean acceptable(Number expected, Number actual, double precision, double zeroThreshold) {
        if (VerificationUtil.isZero(expected, zeroThreshold) && VerificationUtil.isZero(actual, zeroThreshold)) {
            return true;
        }
        double zeroBoundary = expected.doubleValue() * (1.0 - precision);
        double infinityBoundary = expected.doubleValue() * (1.0 + precision);
        if (expected.doubleValue() >= 0.0) {
            return actual.doubleValue() >= zeroBoundary && actual.doubleValue() <= infinityBoundary;
        }
        return actual.doubleValue() <= zeroBoundary && actual.doubleValue() >= infinityBoundary;
    }

    public static boolean isZero(Number value, double zeroThreshold) {
        return value.doubleValue() >= -zeroThreshold && value.doubleValue() <= zeroThreshold;
    }
}

