/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.junit.Assert;
import org.junit.Test;

public class AssociationOutputTest
extends ModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        ModelEvaluator<?> evaluator = this.createModelEvaluator();
        Map<FieldName, ?> arguments = AssociationOutputTest.createArguments("item", Arrays.asList("Cracker", "Coke"));
        Map result = evaluator.evaluate(arguments);
        AssociationOutputTest.checkOutput(Arrays.asList("Cracker"), result, "antecedent");
        AssociationOutputTest.checkOutput(Arrays.asList("Water"), result, "consequent");
        AssociationOutputTest.checkOutput("{Cracker}->{Water}", result, "rule");
        AssociationOutputTest.checkOutput("1", result, "ruleId");
        AssociationOutputTest.checkOutput(1.0, result, "support");
        AssociationOutputTest.checkOutput(1.0, result, "confidence");
        AssociationOutputTest.checkOutput(Float.valueOf(1.0f), result, "lift");
    }

    private static void checkOutput(Object expected, Map<FieldName, ?> result, String name) {
        Assert.assertEquals((Object)expected, result.get(new FieldName(name)));
        Assert.assertEquals((Object)expected, result.get(new FieldName("deprecated_" + name)));
    }
}

