/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ProbabilityClassificationMap;
import org.jpmml.evaluator.VerificationUtil;
import org.junit.Assert;
import org.junit.Test;

public class CategoricalResidualTest
extends ModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        ModelEvaluator<?> evaluator = this.createModelEvaluator();
        Map<FieldName, ?> arguments = CategoricalResidualTest.createArguments(evaluator.getTargetField(), "Y");
        ModelEvaluationContext context = evaluator.createContext(null);
        context.declareAll(arguments);
        ProbabilityClassificationMap response = new ProbabilityClassificationMap();
        response.put((Object)"Y", (Object)0.8);
        response.put((Object)"N", (Object)0.2);
        Map<FieldName, ProbabilityClassificationMap> prediction = Collections.singletonMap(evaluator.getTargetField(), response);
        Map result = OutputUtil.evaluate(prediction, (ModelEvaluationContext)context);
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)0.2, (Number)((Number)result.get(new FieldName("Residual")))));
        arguments = CategoricalResidualTest.createArguments(evaluator.getTargetField(), "N");
        context = evaluator.createContext(null);
        context.declareAll(arguments);
        result = OutputUtil.evaluate(prediction, (ModelEvaluationContext)context);
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)-0.8, (Number)((Number)result.get(new FieldName("Residual")))));
    }
}

