/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.dmg.pmml.AssociationRule;
import org.dmg.pmml.OutputField;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.HasRuleValues;
import org.jpmml.evaluator.MissingResultException;
import org.jpmml.manager.UnsupportedFeatureException;

@Beta
public abstract class Association
implements Computable,
HasRuleValues {
    private List<AssociationRule> associationRules = null;
    private BitSet antecedentFlags = null;
    private BitSet consequentFlags = null;

    protected Association(List<AssociationRule> associationRules, BitSet antecedentFlags, BitSet consequentFlags) {
        this.setAssociationRules(associationRules);
        this.setAntecedentFlags(antecedentFlags);
        this.setConsequentFlags(consequentFlags);
    }

    @Override
    public Object getResult() {
        throw new MissingResultException(null);
    }

    @Override
    public List<AssociationRule> getRuleValues(OutputField.Algorithm algorithm) {
        BitSet flags;
        List<AssociationRule> associationRules = this.getAssociationRules();
        switch (algorithm) {
            case RECOMMENDATION: {
                flags = this.getAntecedentFlags();
                break;
            }
            case EXCLUSIVE_RECOMMENDATION: {
                flags = (BitSet)this.getAntecedentFlags().clone();
                flags.andNot(this.getConsequentFlags());
                break;
            }
            case RULE_ASSOCIATION: {
                flags = (BitSet)this.getAntecedentFlags().clone();
                flags.and(this.getConsequentFlags());
                break;
            }
            default: {
                throw new UnsupportedFeatureException(null, (Enum)algorithm);
            }
        }
        ArrayList result = Lists.newArrayList();
        int i = flags.nextSetBit(0);
        while (i > -1) {
            AssociationRule associationRule = associationRules.get(i);
            result.add(associationRule);
            i = flags.nextSetBit(i + 1);
        }
        return result;
    }

    public List<AssociationRule> getAssociationRules() {
        return this.associationRules;
    }

    private void setAssociationRules(List<AssociationRule> associationRules) {
        this.associationRules = associationRules;
    }

    public BitSet getAntecedentFlags() {
        return this.antecedentFlags;
    }

    private void setAntecedentFlags(BitSet antecedentFlags) {
        this.antecedentFlags = antecedentFlags;
    }

    public BitSet getConsequentFlags() {
        return this.consequentFlags;
    }

    private void setConsequentFlags(BitSet consequentFlags) {
        this.consequentFlags = consequentFlags;
    }
}

