/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.Seconds;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.jpmml.evaluator.TypeUtil;

public class SecondsSinceDate
implements Comparable<SecondsSinceDate> {
    private LocalDate epoch = null;
    private Seconds seconds = null;

    public SecondsSinceDate(int year, LocalDateTime dateTime) {
        this(new LocalDate(year, 1, 1), dateTime);
    }

    public SecondsSinceDate(LocalDate epoch, LocalDateTime dateTime) {
        this(epoch, Seconds.secondsBetween((ReadablePartial)TypeUtil.toMidnight(epoch), (ReadablePartial)dateTime));
    }

    public SecondsSinceDate(LocalDate epoch, Seconds seconds) {
        this.setEpoch(epoch);
        this.setSeconds(seconds);
    }

    @Override
    public int compareTo(SecondsSinceDate that) {
        if (!this.getEpoch().equals((Object)that.getEpoch())) {
            throw new ClassCastException();
        }
        return this.getSeconds().compareTo((BaseSingleFieldPeriod)that.getSeconds());
    }

    public int hashCode() {
        return 37 * this.getEpoch().hashCode() + this.getSeconds().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof SecondsSinceDate) {
            SecondsSinceDate that = (SecondsSinceDate)object;
            return this.getEpoch().equals((Object)that.getEpoch()) && this.getSeconds().equals((Object)that.getSeconds());
        }
        return false;
    }

    public int intValue() {
        return this.getSeconds().getSeconds();
    }

    public LocalDate getEpoch() {
        return this.epoch;
    }

    private void setEpoch(LocalDate epoch) {
        this.epoch = epoch;
    }

    public Seconds getSeconds() {
        return this.seconds;
    }

    private void setSeconds(Seconds seconds) {
        this.seconds = seconds;
    }
}

