/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Equivalence;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.Batch;
import org.jpmml.evaluator.CsvUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.VerificationUtil;

public class BatchUtil {
    private static final double precision = 1.0E-6;
    private static final double zeroThreshold = 1.0E-6;

    private BatchUtil() {
    }

    public static boolean evaluate(Batch batch) throws Exception {
        return BatchUtil.evaluate(batch, 1.0E-6, 1.0E-6);
    }

    public static boolean evaluate(Batch batch, double precision, double zeroThreshold) throws Exception {
        List<MapDifference<FieldName, ?>> differences = BatchUtil.difference(batch, precision, zeroThreshold);
        return Iterables.isEmpty(differences);
    }

    public static Object evaluateDefault(Batch batch) throws Exception {
        ModelEvaluator<?> evaluator = PMMLUtil.createModelEvaluator(batch.getModel());
        Map arguments = Collections.emptyMap();
        Map result = evaluator.evaluate(arguments);
        return result.get(evaluator.getTargetField());
    }

    public static List<MapDifference<FieldName, ?>> difference(Batch batch, final double precision, final double zeroThreshold) throws Exception {
        List input = CsvUtil.load(batch.getInput());
        List<Map<FieldName, String>> output = CsvUtil.load(batch.getOutput());
        ModelEvaluator<?> evaluator = PMMLUtil.createModelEvaluator(batch.getModel());
        List groupFields = evaluator.getGroupFields();
        List targetFields = evaluator.getTargetFields();
        if (groupFields.size() == 1) {
            FieldName groupField = (FieldName)groupFields.get(0);
            input = EvaluatorUtil.groupRows((Object)groupField, input);
        } else if (groupFields.size() > 1) {
            throw new EvaluationException();
        }
        Equivalence<Object> equivalence = new Equivalence<Object>(){

            public boolean doEquivalent(Object expected, Object actual) {
                actual = EvaluatorUtil.decode((Object)actual);
                return VerificationUtil.acceptable((Object)TypeUtil.parseOrCast((DataType)TypeUtil.getDataType((Object)actual), (Object)expected), (Object)actual, (double)precision, (double)zeroThreshold);
            }

            public int doHash(Object object) {
                return object.hashCode();
            }
        };
        if (output.size() > 0) {
            if (input.size() != output.size()) {
                throw new EvaluationException();
            }
            ArrayList differences = Lists.newArrayList();
            for (int i = 0; i < input.size(); ++i) {
                MapDifference difference;
                Map arguments = (Map)input.get(i);
                Map result = evaluator.evaluate(arguments);
                if (targetFields.size() == 0) {
                    result = Maps.newLinkedHashMap((Map)result);
                    result.remove(evaluator.getTargetField());
                }
                if ((difference = Maps.difference(output.get(i), (Map)result, (Equivalence)equivalence)).areEqual()) continue;
                differences.add(difference);
            }
            return differences;
        }
        for (int i = 0; i < input.size(); ++i) {
            Map arguments = (Map)input.get(i);
            evaluator.evaluate(arguments);
        }
        return Collections.emptyList();
    }
}

