/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jpmml.evaluator.ClassificationMap;
import org.junit.Assert;
import org.junit.Test;

public class ClassificationMapTest {
    @Test
    public void increasingOrder() {
        ClassificationMap.Type type = ClassificationMap.Type.SIMILARITY;
        Assert.assertTrue((type.compare(Double.valueOf(0.5), Double.valueOf(0.0)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((type.compare(Double.valueOf(0.0), Double.valueOf(0.5)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((type.compare(Double.valueOf(0.5), Double.valueOf(0.5)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((type.compare(Double.valueOf(1.0), Double.valueOf(0.5)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((type.compare(Double.valueOf(0.5), Double.valueOf(1.0)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void decreasingOrder() {
        ClassificationMap.Type type = ClassificationMap.Type.DISTANCE;
        Assert.assertTrue((type.compare(Double.valueOf(0.5), Double.valueOf(0.0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((type.compare(Double.valueOf(0.0), Double.valueOf(0.5)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((type.compare(Double.valueOf(0.5), Double.valueOf(0.5)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((type.compare(Double.valueOf(1.0), Double.valueOf(0.5)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((type.compare(Double.valueOf(0.5), Double.valueOf(1.0)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void subtract() {
        LinkedHashMap values = Maps.newLinkedHashMap();
        values.put("loud", 0.2);
        values.put("louder", 0.7);
        values.put("insane", 1.0);
        ClassificationMap.subtract((Map)values, Arrays.asList("loud", "louder", "insane"));
        Assert.assertEquals((Object)0.2, values.get("loud"));
        Assert.assertEquals((Object)0.49999999999999994, values.get("louder"));
        Assert.assertEquals((Object)0.30000000000000004, values.get("insane"));
    }
}

