/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MissingValueStrategyType;
import org.dmg.pmml.TreeModel;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.jpmml.evaluator.NodeClassificationMap;
import org.junit.Assert;
import org.junit.Test;

public class MissingValueStrategyTest
extends ModelEvaluatorTest {
    @Test
    public void nullPrediction() throws Exception {
        Map<FieldName, ?> arguments = MissingValueStrategyTest.createArguments("outlook", "sunny", "temperature", null, "humidity", null);
        NodeClassificationMap result = this.evaluate(MissingValueStrategyType.NULL_PREDICTION, arguments);
        Assert.assertEquals(null, (Object)MissingValueStrategyTest.getEntityId(result));
    }

    @Test
    public void lastPrediction() throws Exception {
        Map<FieldName, ?> arguments = MissingValueStrategyTest.createArguments("outlook", "sunny", "temperature", null, "humidity", null);
        NodeClassificationMap result = this.evaluate(MissingValueStrategyType.LAST_PREDICTION, arguments);
        Assert.assertEquals((Object)"2", (Object)MissingValueStrategyTest.getEntityId(result));
        Assert.assertEquals((Object)0.8, (Object)result.getProbability("will play"));
        Assert.assertEquals((Object)0.04, (Object)result.getProbability("may play"));
        Assert.assertEquals((Object)0.16, (Object)result.getProbability("no play"));
    }

    @Test
    public void defaultChildSingle() throws Exception {
        Map<FieldName, ?> arguments = MissingValueStrategyTest.createArguments("outlook", null, "temperature", 40.0, "humidity", 70.0);
        NodeClassificationMap result = this.evaluate(MissingValueStrategyType.DEFAULT_CHILD, 0.8, arguments);
        Assert.assertEquals((Object)"4", (Object)MissingValueStrategyTest.getEntityId(result));
        Assert.assertEquals((Object)0.4, (Object)result.getProbability("will play"));
        Assert.assertEquals((Object)0.0, (Object)result.getProbability("may play"));
        Assert.assertEquals((Object)0.6, (Object)result.getProbability("no play"));
        double missingValuePenatly = 0.8;
        Assert.assertEquals((Object)(0.4 * missingValuePenatly), (Object)result.getConfidence("will play"));
        Assert.assertEquals((Object)(0.0 * missingValuePenatly), (Object)result.getConfidence("may play"));
        Assert.assertEquals((Object)(0.6 * missingValuePenatly), (Object)result.getConfidence("no play"));
    }

    @Test
    public void defaultChildMultiple() throws Exception {
        Map<FieldName, ?> arguments = MissingValueStrategyTest.createArguments("outlook", null, "temperature", null, "humidity", 70.0);
        NodeClassificationMap result = this.evaluate(MissingValueStrategyType.DEFAULT_CHILD, 0.8, arguments);
        Assert.assertEquals((Object)"3", (Object)MissingValueStrategyTest.getEntityId(result));
        Assert.assertEquals((Object)0.9, (Object)result.getProbability("will play"));
        Assert.assertEquals((Object)0.05, (Object)result.getProbability("may play"));
        Assert.assertEquals((Object)0.05, (Object)result.getProbability("no play"));
        double missingValuePenalty = 0.6400000000000001;
        Assert.assertEquals((Object)(0.9 * missingValuePenalty), (Object)result.getConfidence("will play"));
        Assert.assertEquals((Object)(0.05 * missingValuePenalty), (Object)result.getConfidence("may play"));
        Assert.assertEquals((Object)(0.05 * missingValuePenalty), (Object)result.getConfidence("no play"));
    }

    private NodeClassificationMap evaluate(MissingValueStrategyType missingValueStrategy, Map<FieldName, ?> arguments) throws Exception {
        return this.evaluate(missingValueStrategy, null, arguments);
    }

    private NodeClassificationMap evaluate(MissingValueStrategyType missingValueStrategy, Double missingValuePenalty, Map<FieldName, ?> arguments) throws Exception {
        ModelEvaluator<?> evaluator = this.createModelEvaluator();
        TreeModel treeModel = ((TreeModel)evaluator.getModel()).withMissingValueStrategy(missingValueStrategy).withMissingValuePenalty(missingValuePenalty);
        Map result = evaluator.evaluate(arguments);
        return (NodeClassificationMap)result.get(evaluator.getTargetField());
    }
}

