/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.LocalEvaluationContext;
import org.jpmml.evaluator.PredicateUtil;
import org.junit.Assert;
import org.junit.Test;

public class PredicateUtilTest {
    @Test
    public void evaluateSimplePredicate() {
        FieldName age = new FieldName("age");
        SimplePredicate simplePredicate = new SimplePredicate(age, SimplePredicate.Operator.IS_MISSING);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate));
        simplePredicate = simplePredicate.withOperator(SimplePredicate.Operator.IS_NOT_MISSING);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate));
        simplePredicate = simplePredicate.withValue("30");
        simplePredicate = simplePredicate.withOperator(SimplePredicate.Operator.EQUAL);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        Assert.assertEquals(null, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate));
        simplePredicate = simplePredicate.withOperator(SimplePredicate.Operator.NOT_EQUAL);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        Assert.assertEquals(null, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate));
        simplePredicate = simplePredicate.withOperator(SimplePredicate.Operator.LESS_THAN);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        simplePredicate = simplePredicate.withOperator(SimplePredicate.Operator.LESS_OR_EQUAL);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        simplePredicate = simplePredicate.withOperator(SimplePredicate.Operator.GREATER_OR_EQUAL);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
        simplePredicate = simplePredicate.withOperator(SimplePredicate.Operator.GREATER_THAN);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simplePredicate, age, 30));
    }

    @Test
    public void evaluateSurrogateCompoundPredicate() {
        FieldName temperature = new FieldName("temperature");
        FieldName humidity = new FieldName("humidity");
        CompoundPredicate temperaturePredicate = new CompoundPredicate(CompoundPredicate.BooleanOperator.AND).withPredicates(new Predicate[]{new SimplePredicate(temperature, SimplePredicate.Operator.LESS_THAN).withValue("90"), new SimplePredicate(temperature, SimplePredicate.Operator.GREATER_THAN).withValue("50")});
        SimplePredicate humidityPredicate = new SimplePredicate(humidity, SimplePredicate.Operator.GREATER_OR_EQUAL).withValue("80");
        CompoundPredicate compoundPredicate = new CompoundPredicate(CompoundPredicate.BooleanOperator.SURROGATE).withPredicates(new Predicate[]{temperaturePredicate, humidityPredicate});
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, temperature, 70));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, temperature, 40));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, temperature, 100));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, humidity, 90));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate, humidity, 70));
        Assert.assertEquals(null, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate));
    }

    @Test
    public void evaluateBooleanCompoundPredicate() {
        CompoundPredicate compoundPredicate = new CompoundPredicate().withPredicates(new Predicate[]{new True(), new False()});
        compoundPredicate = compoundPredicate.withBooleanOperator(CompoundPredicate.BooleanOperator.AND);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate));
        compoundPredicate = compoundPredicate.withBooleanOperator(CompoundPredicate.BooleanOperator.OR);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate));
        compoundPredicate = compoundPredicate.withBooleanOperator(CompoundPredicate.BooleanOperator.XOR);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)compoundPredicate));
    }

    @Test
    public void evaluateSimpleSetPredicate() {
        FieldName fruit = new FieldName("fruit");
        SimpleSetPredicate simpleSetPredicate = new SimpleSetPredicate(new Array("apple orange", Array.Type.STRING), fruit, SimpleSetPredicate.BooleanOperator.IS_IN);
        Assert.assertEquals(null, (Object)PredicateUtilTest.evaluate((Predicate)simpleSetPredicate));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simpleSetPredicate, fruit, "apple"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simpleSetPredicate, fruit, "pineapple"));
        simpleSetPredicate = simpleSetPredicate.withBooleanOperator(SimpleSetPredicate.BooleanOperator.IS_NOT_IN);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)simpleSetPredicate, fruit, "apple"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)simpleSetPredicate, fruit, "pineapple"));
    }

    @Test
    public void evaluateTrue() {
        True truePredicate = new True();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtilTest.evaluate((Predicate)truePredicate));
    }

    @Test
    public void evaluateFalse() {
        False falsePredicate = new False();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtilTest.evaluate((Predicate)falsePredicate));
    }

    @Test
    public void binaryAnd() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.TRUE, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.TRUE, null));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryAnd((Boolean)Boolean.FALSE, null));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryAnd(null, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryAnd(null, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryAnd(null, null));
    }

    @Test
    public void binaryOr() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryOr((Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryOr((Boolean)Boolean.TRUE, (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryOr((Boolean)Boolean.TRUE, null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryOr((Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryOr((Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryOr((Boolean)Boolean.FALSE, null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryOr(null, (Boolean)Boolean.TRUE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryOr(null, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryOr(null, null));
    }

    @Test
    public void binaryXor() {
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryXor((Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryXor((Boolean)Boolean.TRUE, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryXor((Boolean)Boolean.TRUE, null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)PredicateUtil.binaryXor((Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)PredicateUtil.binaryXor((Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryXor((Boolean)Boolean.FALSE, null));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryXor(null, (Boolean)Boolean.TRUE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryXor(null, (Boolean)Boolean.FALSE));
        Assert.assertEquals(null, (Object)PredicateUtil.binaryXor(null, null));
    }

    private static Boolean evaluate(Predicate predicate) {
        LocalEvaluationContext context = new LocalEvaluationContext();
        return PredicateUtilTest.evaluate(predicate, context);
    }

    private static Boolean evaluate(Predicate predicate, FieldName field, Object value) {
        LocalEvaluationContext context = new LocalEvaluationContext();
        context.declare(field, value);
        return PredicateUtilTest.evaluate(predicate, context);
    }

    private static Boolean evaluate(Predicate predicate, EvaluationContext context) {
        return PredicateUtil.evaluate((Predicate)predicate, (EvaluationContext)context);
    }
}

