/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.Years;
import org.jpmml.evaluator.DaysSinceDate;
import org.jpmml.evaluator.SecondsSinceDate;
import org.jpmml.evaluator.SecondsSinceMidnight;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.junit.Assert;
import org.junit.Test;

public class TypeUtilTest {
    private static final String DATE = "1969-07-20";
    private static final String TIME = "20:17:40";
    private static final String DATE_TIME = "1969-07-20T20:17:40";
    private static final Years DECADE = Years.years((int)10);

    @Test
    public void parseInteger() {
        Assert.assertEquals((Object)1, (Object)TypeUtil.parse((DataType)DataType.INTEGER, (String)"1"));
        Assert.assertEquals((Object)1, (Object)TypeUtil.parse((DataType)DataType.INTEGER, (String)"1.0"));
        Assert.assertEquals((Object)1, (Object)TypeUtil.parse((DataType)DataType.INTEGER, (String)"1e+0"));
    }

    @Test
    public void cast() {
        Assert.assertEquals((Object)"1", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)"1"));
        Assert.assertEquals((Object)"1", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)1));
        Assert.assertEquals((Object)"1.0", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"1.0", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"1.0", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)1.0));
        Assert.assertEquals((Object)"1.0", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)1.0));
        Assert.assertEquals((Object)1, (Object)TypeUtil.cast((DataType)DataType.INTEGER, (Object)1));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)TypeUtil.cast((DataType)DataType.FLOAT, (Object)1));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)TypeUtil.cast((DataType)DataType.FLOAT, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)1.0, (Object)TypeUtil.cast((DataType)DataType.DOUBLE, (Object)1));
        Assert.assertEquals((Object)1.0, (Object)TypeUtil.cast((DataType)DataType.DOUBLE, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)1.0, (Object)TypeUtil.cast((DataType)DataType.DOUBLE, (Object)1.0));
    }

    @Test
    public void castInteger() {
        Assert.assertEquals((Object)1, (Object)TypeUtil.cast((DataType)DataType.INTEGER, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)1, (Object)TypeUtil.cast((DataType)DataType.INTEGER, (Object)Float.valueOf(1.0f)));
        try {
            TypeUtil.cast((DataType)DataType.INTEGER, (Object)Float.valueOf(Math.nextUp(1.0f)));
            Assert.fail();
        }
        catch (TypeCheckException tce) {
            // empty catch block
        }
        Assert.assertEquals((Object)1, (Object)TypeUtil.cast((DataType)DataType.INTEGER, (Object)1.0));
        Assert.assertEquals((Object)1, (Object)TypeUtil.cast((DataType)DataType.INTEGER, (Object)1.0));
        try {
            TypeUtil.cast((DataType)DataType.INTEGER, (Object)Math.nextUp(1.0));
            Assert.fail();
        }
        catch (TypeCheckException typeCheckException) {
            // empty catch block
        }
    }

    @Test
    public void parseDate() {
        LocalDate date = (LocalDate)TypeUtil.parse((DataType)DataType.DATE, (String)DATE);
        Assert.assertEquals((Object)DataType.DATE, (Object)TypeUtil.getDataType((Object)date));
    }

    @Test
    public void parseTime() {
        LocalTime time = (LocalTime)TypeUtil.parse((DataType)DataType.TIME, (String)TIME);
        Assert.assertEquals((Object)DataType.TIME, (Object)TypeUtil.getDataType((Object)time));
    }

    @Test
    public void parseDateTime() {
        LocalDateTime dateTime = (LocalDateTime)TypeUtil.parse((DataType)DataType.DATE_TIME, (String)DATE_TIME);
        Assert.assertEquals((Object)DataType.DATE_TIME, (Object)TypeUtil.getDataType((Object)dateTime));
    }

    @Test
    public void parseDaysSinceDate() {
        DaysSinceDate sixties = (DaysSinceDate)TypeUtil.parse((DataType)DataType.DATE_DAYS_SINCE_1960, (String)DATE);
        DaysSinceDate seventies = (DaysSinceDate)TypeUtil.parse((DataType)DataType.DATE_DAYS_SINCE_1970, (String)DATE);
        DaysSinceDate eighties = (DaysSinceDate)TypeUtil.parse((DataType)DataType.DATE_DAYS_SINCE_1980, (String)DATE);
        Assert.assertEquals((Object)DataType.DATE_DAYS_SINCE_1960, (Object)TypeUtil.getDataType((Object)sixties));
        Assert.assertEquals((Object)DataType.DATE_DAYS_SINCE_1970, (Object)TypeUtil.getDataType((Object)seventies));
        Assert.assertEquals((Object)DataType.DATE_DAYS_SINCE_1980, (Object)TypeUtil.getDataType((Object)eighties));
        Assert.assertEquals((Object)DECADE, (Object)Years.yearsBetween((ReadablePartial)sixties.getEpoch(), (ReadablePartial)seventies.getEpoch()));
        Assert.assertEquals((Object)DECADE, (Object)Years.yearsBetween((ReadablePartial)seventies.getEpoch(), (ReadablePartial)eighties.getEpoch()));
        try {
            int diff = sixties.compareTo(seventies);
            Assert.fail();
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        Assert.assertEquals((Object)sixties, (Object)TypeUtil.cast((DataType)DataType.DATE_DAYS_SINCE_1960, (Object)seventies));
        Assert.assertEquals((Object)sixties, (Object)TypeUtil.cast((DataType)DataType.DATE_DAYS_SINCE_1960, (Object)eighties));
        Assert.assertEquals((Object)seventies, (Object)TypeUtil.cast((DataType)DataType.DATE_DAYS_SINCE_1970, (Object)sixties));
        Assert.assertEquals((Object)seventies, (Object)TypeUtil.cast((DataType)DataType.DATE_DAYS_SINCE_1970, (Object)eighties));
        Assert.assertEquals((Object)eighties, (Object)TypeUtil.cast((DataType)DataType.DATE_DAYS_SINCE_1980, (Object)sixties));
        Assert.assertEquals((Object)eighties, (Object)TypeUtil.cast((DataType)DataType.DATE_DAYS_SINCE_1980, (Object)seventies));
        Assert.assertEquals((long)0L, (long)TypeUtilTest.countDaysSince1960("1960-01-01"));
        Assert.assertEquals((long)1L, (long)TypeUtilTest.countDaysSince1960("1960-01-02"));
        Assert.assertEquals((long)31L, (long)TypeUtilTest.countDaysSince1960("1960-02-01"));
        Assert.assertEquals((long)-1L, (long)TypeUtilTest.countDaysSince1960("1959-12-31"));
        Assert.assertEquals((long)15796L, (long)TypeUtilTest.countDaysSince1960("2003-04-01"));
    }

    @Test
    public void parseSecondsSinceMidnight() {
        SecondsSinceMidnight noon = (SecondsSinceMidnight)TypeUtil.parse((DataType)DataType.TIME_SECONDS, (String)"12:00:00");
        Assert.assertEquals((Object)DataType.TIME_SECONDS, (Object)TypeUtil.getDataType((Object)noon));
        Assert.assertEquals((long)0L, (long)TypeUtilTest.countSecondsSinceMidnight("0:00:00"));
        Assert.assertEquals((long)100L, (long)TypeUtilTest.countSecondsSinceMidnight("0:01:40"));
        Assert.assertEquals((long)200L, (long)TypeUtilTest.countSecondsSinceMidnight("0:03:20"));
        Assert.assertEquals((long)1000L, (long)TypeUtilTest.countSecondsSinceMidnight("0:16:40"));
        Assert.assertEquals((long)86400L, (long)TypeUtilTest.countSecondsSinceMidnight("24:00:00"));
        Assert.assertEquals((long)86401L, (long)TypeUtilTest.countSecondsSinceMidnight("24:00:01"));
        Assert.assertEquals((long)100000L, (long)TypeUtilTest.countSecondsSinceMidnight("27:46:40"));
        Assert.assertEquals((long)19410L, (long)TypeUtilTest.countSecondsSinceMidnight("05:23:30"));
    }

    @Test
    public void parseSecondsSinceDate() {
        SecondsSinceDate sixties = (SecondsSinceDate)TypeUtil.parse((DataType)DataType.DATE_TIME_SECONDS_SINCE_1960, (String)DATE_TIME);
        SecondsSinceDate seventies = (SecondsSinceDate)TypeUtil.parse((DataType)DataType.DATE_TIME_SECONDS_SINCE_1970, (String)DATE_TIME);
        SecondsSinceDate eighties = (SecondsSinceDate)TypeUtil.parse((DataType)DataType.DATE_TIME_SECONDS_SINCE_1980, (String)DATE_TIME);
        Assert.assertEquals((Object)DataType.DATE_TIME_SECONDS_SINCE_1960, (Object)TypeUtil.getDataType((Object)sixties));
        Assert.assertEquals((Object)DataType.DATE_TIME_SECONDS_SINCE_1970, (Object)TypeUtil.getDataType((Object)seventies));
        Assert.assertEquals((Object)DataType.DATE_TIME_SECONDS_SINCE_1980, (Object)TypeUtil.getDataType((Object)eighties));
        Assert.assertEquals((Object)DECADE, (Object)Years.yearsBetween((ReadablePartial)sixties.getEpoch(), (ReadablePartial)seventies.getEpoch()));
        Assert.assertEquals((Object)DECADE, (Object)Years.yearsBetween((ReadablePartial)seventies.getEpoch(), (ReadablePartial)eighties.getEpoch()));
        try {
            int diff = sixties.compareTo(seventies);
            Assert.fail();
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        Assert.assertEquals((Object)sixties, (Object)TypeUtil.cast((DataType)DataType.DATE_TIME_SECONDS_SINCE_1960, (Object)seventies));
        Assert.assertEquals((Object)sixties, (Object)TypeUtil.cast((DataType)DataType.DATE_TIME_SECONDS_SINCE_1960, (Object)eighties));
        Assert.assertEquals((Object)seventies, (Object)TypeUtil.cast((DataType)DataType.DATE_TIME_SECONDS_SINCE_1970, (Object)sixties));
        Assert.assertEquals((Object)seventies, (Object)TypeUtil.cast((DataType)DataType.DATE_TIME_SECONDS_SINCE_1970, (Object)eighties));
        Assert.assertEquals((Object)eighties, (Object)TypeUtil.cast((DataType)DataType.DATE_TIME_SECONDS_SINCE_1980, (Object)sixties));
        Assert.assertEquals((Object)eighties, (Object)TypeUtil.cast((DataType)DataType.DATE_TIME_SECONDS_SINCE_1980, (Object)seventies));
        Assert.assertEquals((long)0L, (long)TypeUtilTest.countSecondsSince1960("1960-01-01T00:00:00"));
        Assert.assertEquals((long)1L, (long)TypeUtilTest.countSecondsSince1960("1960-01-01T00:00:01"));
        Assert.assertEquals((long)60L, (long)TypeUtilTest.countSecondsSince1960("1960-01-01T00:01:00"));
        Assert.assertEquals((long)-1L, (long)TypeUtilTest.countSecondsSince1960("1959-12-31T23:59:59"));
        Assert.assertEquals((long)185403L, (long)TypeUtilTest.countSecondsSince1960("1960-01-03T03:30:03"));
    }

    @Test
    public void getResultDataType() {
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtilTest.getResultDataType(1.0, Float.valueOf(1.0f)));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtilTest.getResultDataType(1.0, 1));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtilTest.getResultDataType(Float.valueOf(1.0f), 1.0));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtilTest.getResultDataType(Float.valueOf(1.0f), 1));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtilTest.getResultDataType(1, 1.0));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtilTest.getResultDataType(1, Float.valueOf(1.0f)));
    }

    @Test
    public void getConstantDataType() {
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getConstantDataType((String)"1.0"));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getConstantDataType((String)"1.0E0"));
        Assert.assertEquals((Object)DataType.STRING, (Object)TypeUtil.getConstantDataType((String)"1.0X"));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)TypeUtil.getConstantDataType((String)"1"));
        Assert.assertEquals((Object)DataType.STRING, (Object)TypeUtil.getConstantDataType((String)"1E0"));
        Assert.assertEquals((Object)DataType.STRING, (Object)TypeUtil.getConstantDataType((String)"1X"));
    }

    private static int countDaysSince1960(String string) {
        DaysSinceDate period = (DaysSinceDate)TypeUtil.parse((DataType)DataType.DATE_DAYS_SINCE_1960, (String)string);
        return period.intValue();
    }

    private static int countSecondsSinceMidnight(String string) {
        SecondsSinceMidnight period = (SecondsSinceMidnight)TypeUtil.parse((DataType)DataType.TIME_SECONDS, (String)string);
        return period.intValue();
    }

    private static int countSecondsSince1960(String string) {
        SecondsSinceDate period = (SecondsSinceDate)TypeUtil.parse((DataType)DataType.DATE_TIME_SECONDS_SINCE_1960, (String)string);
        return period.intValue();
    }

    private static DataType getResultDataType(Object left, Object right) {
        return TypeUtil.getResultDataType((DataType)TypeUtil.getDataType((Object)left), (DataType)TypeUtil.getDataType((Object)right));
    }
}

