/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.manager.ModelManager;

public abstract class ModelEvaluator<M extends Model>
extends ModelManager<M>
implements Evaluator {
    public ModelEvaluator(PMML pmml, M model) {
        super(pmml, model);
    }

    public abstract Map<FieldName, ?> evaluate(ModelEvaluationContext var1);

    @Override
    public FieldValue prepare(FieldName name, Object value) {
        return ArgumentUtil.prepare(this.getDataField(name), this.getMiningField(name), value);
    }

    public ModelEvaluationContext createContext(ModelEvaluationContext parent) {
        return new ModelEvaluationContext(parent, this);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        List miningFields = this.getMiningFields(EnumSet.allOf(FieldUsageType.class));
        ModelEvaluationContext context = this.createContext(null);
        context.declareAll(arguments, Sets.newLinkedHashSet((Iterable)miningFields));
        return this.evaluate(context);
    }

    public <V> V getValue(LoadingCache<M, V> cache) {
        Model model = this.getModel();
        return CacheUtil.getValue(model, cache);
    }
}

