/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.Targets;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ProbabilityClassificationMap;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class TargetUtil {
    private TargetUtil() {
    }

    public static Map<FieldName, ? extends Number> evaluateRegression(Double value, ModelEvaluationContext context) {
        ModelEvaluator<?> modelEvaluator = context.getModelEvaluator();
        return TargetUtil.evaluateRegression(Collections.singletonMap(modelEvaluator.getTargetField(), value), context);
    }

    public static Map<FieldName, ? extends Number> evaluateRegressionDefault(ModelEvaluationContext context) {
        return TargetUtil.evaluateRegression((Double)null, context);
    }

    public static Map<FieldName, ? extends Number> evaluateRegression(Map<FieldName, ? extends Number> predictions, ModelEvaluationContext context) {
        ModelEvaluator<?> modelEvaluator = context.getModelEvaluator();
        Targets targets = modelEvaluator.getTargets();
        if (targets == null || Iterables.isEmpty((Iterable)targets)) {
            return predictions;
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        Set<Map.Entry<FieldName, ? extends Number>> entries = predictions.entrySet();
        for (Map.Entry entry : entries) {
            FieldName key = (FieldName)entry.getKey();
            Number value = (Number)entry.getValue();
            Target target = modelEvaluator.getTarget(key);
            if (target != null) {
                value = value != null ? (Number)TargetUtil.process(target, (Number)entry.getValue()) : (Number)TargetUtil.getDefaultValue(target);
            }
            result.put(key, value);
        }
        return result;
    }

    public static Map<FieldName, ? extends ClassificationMap<?>> evaluateClassification(ClassificationMap<?> value, ModelEvaluationContext context) {
        ModelEvaluator<?> modelEvaluator = context.getModelEvaluator();
        return TargetUtil.evaluateClassification(Collections.singletonMap(modelEvaluator.getTargetField(), value), context);
    }

    public static Map<FieldName, ? extends ClassificationMap<?>> evaluateClassificationDefault(ModelEvaluationContext context) {
        return TargetUtil.evaluateClassification((ClassificationMap)null, context);
    }

    public static Map<FieldName, ? extends ClassificationMap<?>> evaluateClassification(Map<FieldName, ? extends ClassificationMap<?>> predictions, ModelEvaluationContext context) {
        ModelEvaluator<?> modelEvaluator = context.getModelEvaluator();
        Targets targets = modelEvaluator.getTargets();
        if (targets == null || Iterables.isEmpty((Iterable)targets)) {
            return predictions;
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        Set<Map.Entry<FieldName, ClassificationMap<?>>> entries = predictions.entrySet();
        for (Map.Entry entry : entries) {
            FieldName key = (FieldName)entry.getKey();
            ProbabilityClassificationMap<String> value = (ProbabilityClassificationMap<String>)entry.getValue();
            Target target = modelEvaluator.getTarget(key);
            if (target != null && value == null) {
                value = TargetUtil.getPriorProbabilities(target);
            }
            result.put(key, value);
        }
        return result;
    }

    public static Number process(Target target, Number value) {
        Double max;
        double result = value.doubleValue();
        Double min = target.getMin();
        if (min != null) {
            result = Math.max(result, min);
        }
        if ((max = target.getMax()) != null) {
            result = Math.min(result, max);
        }
        result = result * target.getRescaleFactor() + target.getRescaleConstant();
        Target.CastInteger castInteger = target.getCastInteger();
        if (castInteger == null) {
            return result;
        }
        switch (castInteger) {
            case ROUND: {
                return (int)Math.round(result);
            }
            case CEILING: {
                return (int)Math.ceil(result);
            }
            case FLOOR: {
                return (int)Math.floor(result);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)target, (Enum)castInteger);
    }

    public static TargetValue getTargetValue(Target target, Object value) {
        DataType dataType = TypeUtil.getDataType(value);
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            if (!TypeUtil.equals(dataType, value, TypeUtil.parseOrCast(dataType, targetValue.getValue()))) continue;
            return targetValue;
        }
        return null;
    }

    private static Double getDefaultValue(Target target) {
        List values = target.getTargetValues();
        if (values.size() != 1) {
            throw new InvalidFeatureException((PMMLObject)target);
        }
        TargetValue value = (TargetValue)values.get(0);
        if (value.getValue() != null || value.getPriorProbability() != null) {
            throw new InvalidFeatureException((PMMLObject)value);
        }
        return value.getDefaultValue();
    }

    private static ProbabilityClassificationMap<String> getPriorProbabilities(Target target) {
        ProbabilityClassificationMap<String> result = new ProbabilityClassificationMap<String>();
        List values = target.getTargetValues();
        for (TargetValue value : values) {
            if (value.getDefaultValue() != null) {
                throw new InvalidFeatureException((PMMLObject)value);
            }
            result.put(value.getValue(), value.getPriorProbability());
        }
        return result;
    }
}

