/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorTest;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.TargetUtil;
import org.junit.Assert;
import org.junit.Test;

public class PriorProbabilitiesTest
extends ModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        ModelEvaluator<?> evaluator = this.createModelEvaluator();
        ModelEvaluationContext context = evaluator.createContext(null);
        Map predictions = TargetUtil.evaluateClassificationDefault((ModelEvaluationContext)context);
        Assert.assertEquals((long)1L, (long)predictions.size());
        ProbabilityDistribution response = (ProbabilityDistribution)predictions.get(evaluator.getTargetField());
        Assert.assertEquals((Object)0.02, (Object)response.getProbability("YES"));
        Assert.assertEquals((Object)0.98, (Object)response.getProbability("NO"));
        Map result = OutputUtil.evaluate((Map)predictions, (ModelEvaluationContext)context);
        FieldName field = new FieldName("I_response");
        FieldName displayField = new FieldName("U_response");
        Assert.assertEquals((Object)"NO", result.get(field));
        Assert.assertEquals((Object)"No", result.get(displayField));
        Assert.assertEquals((Object)DataType.STRING, (Object)OutputUtil.getDataType((OutputField)evaluator.getOutputField(field), evaluator));
        Assert.assertEquals((Object)DataType.STRING, (Object)OutputUtil.getDataType((OutputField)evaluator.getOutputField(displayField), evaluator));
        Assert.assertEquals((Object)0.02, result.get(new FieldName("P_responseYes")));
        Assert.assertEquals((Object)0.98, result.get(new FieldName("P_responseNo")));
    }

    @Test
    public void evaluateEmptyTarget() throws Exception {
        ModelEvaluator<?> evaluator = this.createModelEvaluator();
        Targets targets = evaluator.getTargets();
        for (Target target : targets) {
            List targetValues = target.getTargetValues();
            targetValues.clear();
        }
        ModelEvaluationContext context = evaluator.createContext(null);
        Map predictions = TargetUtil.evaluateClassificationDefault((ModelEvaluationContext)context);
        Assert.assertEquals((long)1L, (long)predictions.size());
        Classification response = (Classification)predictions.get(evaluator.getTargetField());
        Assert.assertEquals(null, (Object)response);
    }
}

