/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeRangeMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Interval;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TableLocator;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class DiscretizationUtil {
    private static final LoadingCache<Discretize, RangeMap<Double, String>> binRangeCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Discretize, RangeMap<Double, String>>(){

        public RangeMap<Double, String> load(Discretize discretize) {
            return ImmutableRangeMap.copyOf((RangeMap)DiscretizationUtil.parseBinRanges(discretize));
        }
    });

    private DiscretizationUtil() {
    }

    public static FieldValue discretize(Discretize discretize, FieldValue value) {
        String result = DiscretizationUtil.discretize(discretize, value.asNumber().doubleValue());
        return FieldValueUtil.create(discretize.getDataType(), null, (Object)result);
    }

    public static String discretize(Discretize discretize, double value) {
        RangeMap<Double, String> binRanges = CacheUtil.getValue(discretize, binRangeCache);
        Map.Entry entry = binRanges.getEntry((Comparable)Double.valueOf(value));
        if (entry != null) {
            return (String)entry.getValue();
        }
        return discretize.getDefaultValue();
    }

    public static FieldValue mapValue(MapValues mapValues, Map<String, FieldValue> values) {
        Table<Integer, String, String> table;
        Map<String, String> row;
        DataType dataType = mapValues.getDataType();
        TableLocator tableLocator = mapValues.getTableLocator();
        if (tableLocator != null) {
            throw new UnsupportedFeatureException((PMMLObject)tableLocator);
        }
        InlineTable inlineTable = mapValues.getInlineTable();
        if (inlineTable != null && (row = InlineTableUtil.match(table = InlineTableUtil.getContent(inlineTable), values)) != null) {
            String result = row.get(mapValues.getOutputColumn());
            if (result == null) {
                throw new EvaluationException((PMMLObject)mapValues);
            }
            return FieldValueUtil.create(dataType, null, (Object)result);
        }
        return FieldValueUtil.create(dataType, null, (Object)mapValues.getDefaultValue());
    }

    public static Range<Double> toRange(Interval interval) {
        Double leftMargin = interval.getLeftMargin();
        Double rightMargin = interval.getRightMargin();
        if (leftMargin == null && rightMargin == null) {
            throw new InvalidFeatureException((PMMLObject)interval);
        }
        if (leftMargin != null && rightMargin != null && leftMargin.compareTo(rightMargin) > 0) {
            throw new InvalidFeatureException((PMMLObject)interval);
        }
        Interval.Closure closure = interval.getClosure();
        switch (closure) {
            case OPEN_OPEN: {
                if (leftMargin == null) {
                    return Range.lessThan((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.greaterThan((Comparable)leftMargin);
                }
                return Range.open((Comparable)leftMargin, (Comparable)rightMargin);
            }
            case OPEN_CLOSED: {
                if (leftMargin == null) {
                    return Range.atMost((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.greaterThan((Comparable)leftMargin);
                }
                return Range.openClosed((Comparable)leftMargin, (Comparable)rightMargin);
            }
            case CLOSED_OPEN: {
                if (leftMargin == null) {
                    return Range.lessThan((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.atLeast((Comparable)leftMargin);
                }
                return Range.closedOpen((Comparable)leftMargin, (Comparable)rightMargin);
            }
            case CLOSED_CLOSED: {
                if (leftMargin == null) {
                    return Range.atMost((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.atLeast((Comparable)leftMargin);
                }
                return Range.closed((Comparable)leftMargin, (Comparable)rightMargin);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)interval, (Enum<?>)closure);
    }

    private static RangeMap<Double, String> parseBinRanges(Discretize discretize) {
        TreeRangeMap result = TreeRangeMap.create();
        List discretizeBins = discretize.getDiscretizeBins();
        for (DiscretizeBin discretizeBin : discretizeBins) {
            Interval interval = discretizeBin.getInterval();
            String binValue = discretizeBin.getBinValue();
            if (interval == null || binValue == null) {
                throw new InvalidFeatureException((PMMLObject)discretizeBin);
            }
            Range<Double> range = DiscretizationUtil.toRange(interval);
            result.put(range, (Object)binValue);
        }
        return result;
    }
}

